#############################################################
#
# netkitrusers
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITRUSERS_SOURCE:=netkit-rusers.tar.gz
NETKITRUSERS_SITE:=rusers://rusers.uk.linux.org/pub/linux/Networking/netkit/
NETKITRUSERS_DIR:=$(BUILD_DIR)/${shell basename $(NETKITRUSERS_SOURCE) .tar.gz}

NETKITRUSERS_CAT:=zcat
else
# using CVS
NETKITRUSERS_DIR:=$(BUILD_DIR)/netkit-rusers
endif

NETKITRUSERS_BINARY:=rusers/rusers
NETKITRUSERS_TARGET_BINARY:=usr/bin/rusers

ifneq ($(USE_CVS),true)
nekitrusers-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITRUSERS_SITE)/$(NETKITRUSERS_SOURCE)

netkitrusers-source: $(DL_DIR)/$(NETKITRUSERS_SOURCE)
else
netkitrusers-source:
endif

NETKITRUSERS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-rusers $(CVS_TAG) $(CVS_PREFIX)netkit-rusers

netkitrusers-checkout:
	@$(NETKITRUSERS_CVSCO)

$(NETKITRUSERS_DIR)/.unpacked: $(DL_DIR)/$(NETKITRUSERS_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITRUSERS_CAT) $(DL_DIR)/$(NETKITRUSERS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITRUSERS_CVSCO)
endif
	sed -i -e 's,^RUSERSX=/usr,RUSERSX=$(STAGING_DIR)/usr,' $(NETKITRUSERS_DIR)/rpc.rusersd/Makefile $(NETKITRUSERS_DIR)/rusers/Makefile
	cat $(SOURCE_DIR)/netkit-rusers.patch | \
	  patch -d $(NETKITRUSERS_DIR) -p1
	touch $(NETKITRUSERS_DIR)/.unpacked

$(STAGING_DIR)/usr/include/rpcsvc/rusers.h:
	cd $(STAGING_DIR)/usr/include/rpcsvc && \
		for H in *.x ; do \
			OFNAME=`echo $$H | sed 's,\.x,.h,'` ;\
			if [ ! -e "$$OFNAME" ]; then \
				rpcgen -h -o $$OFNAME $$H ;\
			fi ;\
		done

$(NETKITRUSERS_DIR)/.configured: $(NETKITRUSERS_DIR)/.unpacked $(STAGING_DIR)/usr/include/rpcsvc/rusers.h
	(cd $(NETKITRUSERS_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITRUSERS_DIR)/.configured

$(NETKITRUSERS_DIR)/$(NETKITRUSERS_BINARY): $(NETKITRUSERS_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITRUSERS_DIR)

$(TARGET_DIR)/$(NETKITRUSERS_TARGET_BINARY): $(NETKITRUSERS_DIR)/$(NETKITRUSERS_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(NETKITRUSERS_DIR) install
	$(STRIP) $(TARGET_DIR)/$(NETKITRUSERS_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/rpc.rusersd \
		$(TARGET_DIR)/usr/bin/rup
	sed -i -e "s~^# *rusersd.*~rusersd/2-3\tdgram\trpc/udp\twait\troot\t/usr/sbin/tcpd\trpc.rusersd~;" $(TARGET_DIR)/etc/inetd.conf
	mkdir -p $(DOC_DIR)/doc/netkit-rusers
	for f in BUGS README ; do \
	    install -m0644 $(NETKITRUSERS_DIR)/$$f $(DOC_DIR)/doc/netkit-rusers/$$f ; \
	done

netkitrusers: uclibc $(TARGET_DIR)/$(NETKITRUSERS_TARGET_BINARY)

netkitrusers-clean:
	-rm -f $(TARGET_DIR)/$(NETKITRUSERS_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/rpc.rusersd \
		$(TARGET_DIR)/usr/bin/rup
	-$(MAKE) -C $(NETKITRUSERS_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-rusers

netkitrusers-dirclean:
	rm -rf $(NETKITRUSERS_DIR)

