#############################################################
#
# rsync
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
RSYNC_SOURCE:=rsync.tar.gz
RSYNC_SITE:=ftp://ftp.gnu.org/gnu/rsync
RSYNC_CAT:=zcat
endif

RSYNC_DIR:=$(BUILD_DIR)/rsync
RSYNC_BINARY:=rsync
RSYNC_TARGET_BINARY:=usr/bin/rsync

ifneq ($(USE_CVS),true)
rsync-fetch:
	 $(WGET) -P $(DL_DIR) $(RSYNC_SITE)/$(RSYNC_SOURCE)

rsync-source: $(DL_DIR)/$(RSYNC_SOURCE)
else
rsync-source:
endif

RSYNC_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d rsync $(CVS_TAG) $(CVS_PREFIX)rsync

rsync-checkout:
	@$(RSYNC_CVSCO)

$(RSYNC_DIR)/.unpacked: $(DL_DIR)/$(RSYNC_SOURCE)
ifneq ($(USE_CVS),true)
	$(RSYNC_CAT) $(DL_DIR)/$(RSYNC_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(RSYNC_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(RSYNC_DIR)/
	touch $(RSYNC_DIR)/.unpacked

$(RSYNC_DIR)/.configured: $(RSYNC_DIR)/.unpacked
	(cd $(RSYNC_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		rsync_cv_HAVE_GETTIMEOFDAY_TZ=yes \
		rsync_cv_HAVE_LONGLONG=yes \
		rsync_cv_HAVE_UNSIGNED_CHAR=yes \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--enable-ipv6 \
	);
	touch  $(RSYNC_DIR)/.configured

$(RSYNC_DIR)/$(RSYNC_BINARY): $(RSYNC_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(RSYNC_DIR)

$(TARGET_DIR)/$(RSYNC_TARGET_BINARY): $(RSYNC_DIR)/$(RSYNC_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(RSYNC_DIR) install
	$(STRIP) $(TARGET_DIR)/$(RSYNC_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/rsync
	@for f in COPYING NEWS README doc/rsync.sgml ; do \
		install -m0644 $(RSYNC_DIR)/$$f $(DOC_DIR)/doc/rsync/`basename $$f` ;\
	done

rsync: uclibc $(TARGET_DIR)/$(RSYNC_TARGET_BINARY)

rsync-clean:
	-rm -f $(TARGET_DIR)/$(RSYNC_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/man/man1/rsync.1
	-rm -f $(TARGET_DIR)/usr/man/man5/rsyncd.conf.5
	-rm -rf $(DOC_DIR)/doc/rsync
	-$(MAKE) -C $(RSYNC_DIR) clean

rsync-dirclean:
	rm -rf $(RSYNC_DIR)
endif

