#############################################################
#
# tcp_wrappers
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
TCP_WRAPPERS_SOURCE:=tcp_wrappers.tar.gz
TCP_WRAPPERS_SITE:=ftp://ftp.gnu.org/gnu/tcp_wrappers
TCP_WRAPPERS_CAT:=zcat
endif

TCP_WRAPPERS_DIR:=$(BUILD_DIR)/tcp_wrappers
TCP_WRAPPERS_BINARY:=tcpd
TCP_WRAPPERS_TARGET_BINARY:=usr/sbin/tcpd
LIBWRAP_MAJOR:=0
LIBWRAP_MINOR:=7
LIBWRAP_REL:=6

ifneq ($(USE_CVS),true)
tcp_wrappers-fetch:
	 $(WGET) -P $(DL_DIR) $(TCP_WRAPPERS_SITE)/$(TCP_WRAPPERS_SOURCE)

tcp_wrappers-source: $(DL_DIR)/$(TCP_WRAPPERS_SOURCE)
else
tcp_wrappers-source:
endif

TCP_WRAPPERS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d tcp_wrappers $(CVS_TAG) $(CVS_PREFIX)tcp_wrappers

tcp_wrappers-checkout:
	@$(TCP_WRAPPERS_CVSCO)

$(TCP_WRAPPERS_DIR)/.unpacked: $(DL_DIR)/$(TCP_WRAPPERS_SOURCE)
ifneq ($(USE_CVS),true)
	$(TCP_WRAPPERS_CAT) $(DL_DIR)/$(TCP_WRAPPERS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(TCP_WRAPPERS_CVSCO)
endif
	touch $(TCP_WRAPPERS_DIR)/.unpacked

$(TCP_WRAPPERS_DIR)/$(TCP_WRAPPERS_BINARY): $(TCP_WRAPPERS_DIR)/.unpacked
	$(MAKE) RPM_OPT_FLAGS="-fPIC -DPIC -D_REENTRANT -DHAVE_STRERROR" MAJOR=$(LIBWRAP_MAJOR) MINOR=$(LIBWRAP_MINOR) REL=$(LIBWRAP_REL) CC=$(TARGET_CC) -C $(TCP_WRAPPERS_DIR) linux

$(TARGET_DIR)/$(TCP_WRAPPERS_TARGET_BINARY): $(TCP_WRAPPERS_DIR)/$(TCP_WRAPPERS_BINARY)
	cp $(TCP_WRAPPERS_DIR)/hosts_access.3 $(TARGET_DIR)/usr/man/man3
	cp $(TCP_WRAPPERS_DIR)/hosts_access.5 $(TCP_WRAPPERS_DIR)/hosts_options.5 $(TARGET_DIR)/usr/man/man5
	cp $(TCP_WRAPPERS_DIR)/tcpd.8 $(TCP_WRAPPERS_DIR)/tcpdchk.8 $(TCP_WRAPPERS_DIR)/tcpdmatch.8 $(TARGET_DIR)/usr/man/man8
	ln -sf hosts_access.5 $(TARGET_DIR)/usr/man/man5/hosts.allow.5
	ln -sf hosts_access.5 $(TARGET_DIR)/usr/man/man5/hosts.deny.5
	cp -a $(TCP_WRAPPERS_DIR)/libwrap.a $(STAGING_DIR)/usr/lib
	cp -a $(TCP_WRAPPERS_DIR)/libwrap.so* $(TARGET_DIR)/usr/lib
	cp -a $(TCP_WRAPPERS_DIR)/libwrap.so* $(STAGING_DIR)/usr/lib
	$(STRIP) $(TARGET_DIR)/usr/lib/libwrap.so*
	cp $(TCP_WRAPPERS_DIR)/tcpd.h $(STAGING_DIR)/usr/include
	install -m755 $(TCP_WRAPPERS_DIR)/safe_finger $(TARGET_DIR)/usr/sbin
	install -m711 $(TCP_WRAPPERS_DIR)/tcpd $(TARGET_DIR)/usr/sbin
	install -m755 $(TCP_WRAPPERS_DIR)/try-from $(TARGET_DIR)/usr/sbin
	$(STRIP) $(TARGET_DIR)/$(TCP_WRAPPERS_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/safe_finger \
		$(TARGET_DIR)/usr/sbin/try-from
	install -d $(DOC_DIR)/doc/tcp_wrappers
	@for f in BLURB DISCLAIMER Banners.Makefile README README.NIS ; do \
		install -m0644 $(TCP_WRAPPERS_DIR)/$$f $(DOC_DIR)/doc/tcp_wrappers/$$f ;\
	done

tcp_wrappers: uclibc popt $(TARGET_DIR)/$(TCP_WRAPPERS_TARGET_BINARY)

tcp_wrappers-clean:
	-rm -f $(TARGET_DIR)/usr/man/man3/hosts_access.3 \
		$(TARGET_DIR)/usr/man/man5/hosts_access.5 \
		$(TARGET_DIR)/usr/man/man5/hosts_options.5 \
		$(TARGET_DIR)/usr/man/man8/{tcpd.8,tcpdchk.8,tcpdmatch.8} \
		$(TARGET_DIR)/usr/man/man5/hosts.allow.5 \
		$(TARGET_DIR)/usr/man/man5/hosts.deny.5 \
		$(STAGING_DIR)/usr/lib/libwrap.a \
		$(TARGET_DIR)/usr/lib/libwrap.so* \
		$(STAGING_DIR)/usr/lib/libwrap.so* \
		$(STAGING_DIR)/usr/include/tcpd.h \
		$(TARGET_DIR)/usr/sbin/{safe_finger,tcpd,try-from}
	-rm -f $(TCP_WRAPPERS_DIR)/libwrap.so*
	-rm -rf $(DOC_DIR)/doc/tcp_wrappers
	-$(MAKE) -C $(TCP_WRAPPERS_DIR) clean

tcp_wrappers-dirclean:
	rm -rf $(TCP_WRAPPERS_DIR)
endif

