/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedDataRow;
import org.hsqldb.DiskNode;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class CachedRow
extends Row {
    static final int NO_POS = -1;
    protected Table tTable;
    int storageSize;
    protected boolean hasDataChanged;
    boolean hasNodesChanged;

    CachedRow() {
    }

    public static CachedRow newCachedRow(Table t, Object[] o) throws HsqlException {
        if (t.isText) {
            return new CachedDataRow(t, o);
        }
        return new CachedRow(t, o);
    }

    CachedRow(Table t, Object[] o) throws HsqlException {
        this.tTable = t;
        int indexcount = t.getIndexCount();
        Node n = this.nPrimaryNode = Node.newNode(this, 0, t);
        int i = 1;
        while (i < indexcount) {
            n = n.nNext = Node.newNode(this, i, t);
            ++i;
        }
        this.oData = o;
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public CachedRow(Table t, RowInputInterface in) throws IOException, HsqlException {
        this.tTable = t;
        this.iPos = in.getPos();
        this.storageSize = in.getSize();
        int indexcount = t.getIndexCount();
        Node n = this.nPrimaryNode = Node.newNode(this, in, 0, t);
        int i = 1;
        while (i < indexcount) {
            n = n.nNext = Node.newNode(this, in, i, t);
            ++i;
        }
        this.oData = in.readData(this.tTable.getColumnTypes());
    }

    private void readRowInfo(RowInputInterface in) throws IOException, HsqlException {
    }

    public void delete() throws HsqlException {
        super.delete();
        this.hasDataChanged = false;
        this.hasNodesChanged = false;
        this.tTable = null;
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public void setPos(int pos) {
        this.iPos = pos;
    }

    void setChanged() {
        this.hasNodesChanged = true;
    }

    public boolean hasChanged() {
        return this.hasNodesChanged;
    }

    public Table getTable() {
        return this.tTable;
    }

    public int getRealSize(RowOutputInterface out) {
        return this.tTable.getIndexCount() * 16 + out.getSize(this);
    }

    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    public synchronized boolean isKeepInMemory() {
        Node n = this.nPrimaryNode;
        while (n != null) {
            if (n.isRoot()) {
                return true;
            }
            n = n.nNext;
        }
        return false;
    }

    synchronized Row getUpdatedRow() throws HsqlException {
        return this.tTable == null ? null : (CachedRow)this.tTable.rowStore.get(this.iPos);
    }

    void setNewNodes() {
    }

    public void write(RowOutputInterface out) {
        try {
            this.writeNodes(out);
            if (this.hasDataChanged) {
                out.writeData(this.oData, this.tTable);
                out.writeEnd();
                this.hasDataChanged = false;
            }
        }
        catch (IOException iOException) {}
    }

    private void writeRowInfo(RowOutputInterface out) {
    }

    public void write(RowOutputInterface out, IntLookup lookup) {
        out.writeSize(this.storageSize);
        Node rownode = this.nPrimaryNode;
        while (rownode != null) {
            ((DiskNode)rownode).writeTranslate(out, lookup);
            rownode = rownode.nNext;
        }
        out.writeData(this.getData(), this.getTable());
        out.writeEnd();
    }

    private void writeNodes(RowOutputInterface out) throws IOException {
        out.writeSize(this.storageSize);
        Node n = this.nPrimaryNode;
        while (n != null) {
            n.write(out);
            n = n.nNext;
        }
        this.hasNodesChanged = false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedRow) {
            return ((CachedRow)obj).iPos == this.iPos;
        }
        return false;
    }

    public int hashCode() {
        return this.iPos;
    }
}

