/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongKeyIntValueHashMap;

public class TransactionManager {
    LongKeyIntValueHashMap rowSessionMap;
    boolean reWriteProtect;
    Database database;
    private long globalActionTimestamp = 0L;

    TransactionManager(Database db) {
        this.database = db;
        this.rowSessionMap = new LongKeyIntValueHashMap(true);
    }

    public void setReWriteProtection(boolean value) {
        this.reWriteProtect = value;
    }

    void checkDelete(Session session, Row row) throws HsqlException {
    }

    void checkDelete(Session session, HashMappedList rowSet) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int sessionid = session.getId();
        int i = 0;
        int size = rowSet.size();
        while (i < size) {
            Row row = (Row)rowSet.getKey(i);
            long rowid = row.getId();
            if (this.rowSessionMap.get(rowid, sessionid) != sessionid) {
                throw Trace.error(117, 122);
            }
            ++i;
        }
    }

    void checkDelete(Session session, HsqlArrayList rowSet) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int sessionid = session.getId();
        int i = 0;
        int size = rowSet.size();
        while (i < size) {
            Row row = (Row)rowSet.get(i);
            long rowid = row.getId();
            if (this.rowSessionMap.get(rowid, sessionid) != sessionid) {
                throw Trace.error(117, 122);
            }
            ++i;
        }
    }

    void commit(Session session) {
        Object[] list = session.rowActionList.getArray();
        int size = session.rowActionList.size();
        int i = 0;
        while (i < size) {
            Transaction tx = (Transaction)list[i];
            long rowid = tx.row.getId();
            tx.commit(session);
            this.rowSessionMap.remove(rowid);
            ++i;
        }
        session.rowActionList.clear();
        session.savepoints.clear();
    }

    synchronized void rollback(Session session) {
        this.rollbackTransactions(session, 0, false);
        session.savepoints.clear();
    }

    void rollbackSavepoint(Session session, String name) throws HsqlException {
        int index = session.savepoints.getIndex(name);
        if (index < 0) {
            throw Trace.error(44, name);
        }
        Integer oi = (Integer)session.savepoints.get(index);
        int limit = oi;
        this.rollbackTransactions(session, limit, false);
        while (session.savepoints.size() > index) {
            session.savepoints.remove(session.savepoints.size() - 1);
        }
    }

    void rollbackTransactions(Session session, int limit, boolean log) {
        Transaction tx;
        Object[] list = session.rowActionList.getArray();
        int size = session.rowActionList.size();
        int i = size - 1;
        while (i >= limit) {
            tx = (Transaction)list[i];
            tx.rollback(session, log);
            --i;
        }
        i = limit;
        while (i < size) {
            tx = (Transaction)list[i];
            long rowid = tx.row.getId();
            this.rowSessionMap.remove(rowid);
            ++i;
        }
        session.rowActionList.setSize(limit);
    }

    void addTransaction(Session session, Transaction transaction) {
        if (this.reWriteProtect) {
            this.rowSessionMap.put(transaction.row.getId(), session.getId());
        }
    }

    long nextActionTimestamp() {
        ++this.globalActionTimestamp;
        return this.globalActionTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    Transaction[] getTransactionList() {
        sessions = this.database.sessionManager.getAllSessions();
        tIndex = new int[sessions.length];
        transactionCount = 0;
        actioncount = 0;
        i = 0;
        while (i < sessions.length) {
            actioncount += sessions[i].getTransactionSize();
            ++i;
        }
        transactions = new Transaction[actioncount];
        block1: while (true) {
            found = false;
            minChangeNo = 0x7FFFFFFFFFFFFFFFL;
            sessionIndex = 0;
            i = 0;
            while (i < sessions.length) {
                tSize = sessions[i].getTransactionSize();
                if (tIndex[i] < tSize) {
                    current = (Transaction)sessions[i].rowActionList.get(tIndex[i]);
                    if (current.SCN < minChangeNo) {
                        minChangeNo = current.SCN;
                        sessionIndex = i;
                    }
                    found = true;
                }
                ++i;
            }
            if (!found) break;
            currentList = sessions[sessionIndex].rowActionList;
            while (true) {
                if (tIndex[sessionIndex] >= currentList.size()) continue block1;
                current = (Transaction)currentList.get(tIndex[sessionIndex]);
                if (current.SCN == minChangeNo + 1L) {
                    ++minChangeNo;
                }
                if (current.SCN == minChangeNo) ** break;
                continue block1;
                transactions[transactionCount++] = current;
                v0 = sessionIndex;
                tIndex[v0] = tIndex[v0] + 1;
            }
            break;
        }
        return transactions;
    }

    public DoubleIntIndex getTransactionIDList() {
        Session[] sessions = this.database.sessionManager.getAllSessions();
        DoubleIntIndex lookup = new DoubleIntIndex(10, false);
        lookup.setKeysSearchTarget();
        int i = 0;
        while (i < sessions.length) {
            HsqlArrayList tlist = sessions[i].rowActionList;
            int j = 0;
            int size = tlist.size();
            while (j < size) {
                Transaction tx = (Transaction)tlist.get(j);
                if (tx.tTable.getTableType() == 4) {
                    lookup.addUnique(tx.row.getPos(), 0);
                }
                ++j;
            }
            ++i;
        }
        return lookup;
    }

    public void convertTransactionIDs(DoubleIntIndex lookup) {
        Session[] sessions = this.database.sessionManager.getAllSessions();
        int i = 0;
        while (i < sessions.length) {
            HsqlArrayList tlist = sessions[i].rowActionList;
            int j = 0;
            int size = tlist.size();
            while (j < size) {
                Transaction tx = (Transaction)tlist.get(j);
                if (tx.tTable.getTableType() == 4) {
                    int pos = lookup.lookupFirstEqual(tx.row.getPos());
                    tx.row.setPos(pos);
                }
                ++j;
            }
            ++i;
        }
    }
}

