/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputBinary
extends RowOutputBase {
    private static final int INT_STORE_SIZE = 4;
    int storageSize;

    public RowOutputBinary() {
    }

    public RowOutputBinary(int initialSize) {
        super(initialSize);
    }

    public RowOutputBinary(byte[] buffer) {
        super(buffer);
    }

    public void writeShortData(short i) {
        this.writeShort(i);
    }

    public void writeIntData(int i) {
        this.writeInt(i);
    }

    public void writeIntData(int i, int position) {
        int temp = this.count;
        this.count = position;
        this.writeInt(i);
        if (this.count < temp) {
            this.count = temp;
        }
    }

    public void writeLongData(long i) {
        this.writeLong(i);
    }

    public void writeEnd() {
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    public void writeSize(int size) {
        this.storageSize = size;
        this.writeInt(size);
    }

    public void writeType(int type) {
        this.writeShort(type);
    }

    public void writeString(String s) {
        int temp = this.count;
        this.writeInt(0);
        StringConverter.writeUTF(s, this);
        this.writeIntData(this.count - temp - 4, temp);
    }

    public int getSize(CachedRow row) {
        Object[] data = row.getData();
        int[] type = row.getTable().getColumnTypes();
        int cols = row.getTable().getColumnCount();
        return 4 + RowOutputBinary.getSize(data, cols, type);
    }

    public static int getRowSize(CachedRow row) {
        Object[] data = row.getData();
        int[] type = row.getTable().getColumnTypes();
        int cols = row.getTable().getColumnCount();
        return RowOutputBinary.getSize(data, cols, type);
    }

    protected void writeFieldType(int type) {
        this.write(1);
    }

    protected void writeNull(int type) {
        this.write(0);
    }

    protected void writeChar(String s, int t) {
        this.writeString(s);
    }

    protected void writeSmallint(Number o) {
        this.writeShort(o.intValue());
    }

    protected void writeInteger(Number o) {
        this.writeInt(o.intValue());
    }

    protected void writeBigint(Number o) {
        this.writeLong(o.longValue());
    }

    protected void writeReal(Double o, int type) {
        this.writeLong(Double.doubleToLongBits(o));
    }

    protected void writeDecimal(BigDecimal o) {
        int scale = o.scale();
        BigInteger bigint = JavaSystem.getUnscaledValue(o);
        byte[] bytearr = bigint.toByteArray();
        this.writeByteArray(bytearr);
        this.writeInt(scale);
    }

    protected void writeBit(Boolean o) {
        this.write(o != false ? 1 : 0);
    }

    protected void writeDate(Date o) {
        this.writeLong(o.getTime());
    }

    protected void writeTime(Time o) {
        this.writeLong(o.getTime());
    }

    protected void writeTimestamp(Timestamp o) {
        this.writeLong(o.getTime());
        this.writeInt(o.getNanos());
    }

    protected void writeOther(JavaObject o) {
        this.writeByteArray(o.getBytes());
    }

    protected void writeBinary(Binary o, int t) {
        this.writeByteArray(o.getBytes());
    }

    protected void writeByteArray(byte[] b) {
        this.writeInt(b.length);
        this.write(b, 0, b.length);
    }

    private static int getSize(Object[] data, int l, int[] type) {
        int s = 0;
        int i = 0;
        while (i < l) {
            Object o = data[i];
            ++s;
            if (o != null) {
                switch (type[i]) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 12: 
                    case 100: {
                        s += 4;
                        s += StringConverter.getUTFSize((String)o);
                        break;
                    }
                    case -6: 
                    case 5: {
                        s += 2;
                        break;
                    }
                    case 4: {
                        s += 4;
                        break;
                    }
                    case -5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        s += 8;
                        break;
                    }
                    case 2: 
                    case 3: {
                        s += 8;
                        BigDecimal bigdecimal = (BigDecimal)o;
                        BigInteger bigint = JavaSystem.getUnscaledValue(bigdecimal);
                        s += bigint.toByteArray().length;
                        break;
                    }
                    case 16: {
                        ++s;
                        break;
                    }
                    case 91: 
                    case 92: {
                        s += 8;
                        break;
                    }
                    case 93: {
                        s += 12;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        s += 4;
                        s += ((Binary)o).getBytesLength();
                        break;
                    }
                    case 1111: {
                        JavaObject jo = (JavaObject)o;
                        s += 4;
                        s += jo.getBytesLength();
                        break;
                    }
                    default: {
                        Trace.printSystemOut("20 " + Types.getTypeString(type[i]));
                    }
                }
            }
            ++i;
        }
        return s;
    }

    public void ensureRoom(int extra) {
        super.ensureRoom(extra);
    }

    public void reset() {
        super.reset();
        this.storageSize = 0;
    }

    public void reset(int newSize) {
        super.reset(newSize);
        this.storageSize = 0;
    }

    public void setBuffer(byte[] buffer) {
        this.buf = buffer;
        this.reset();
    }
}

