/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.assertion;

import org.apache.maven.surefire.assertion.SurefireAssertionFailedException;
import org.apache.maven.surefire.assertion.SurefireComparisonFailureException;

public class SurefireAssert {
    private SurefireAssert() {
    }

    public static void fail() {
        throw new SurefireAssertionFailedException();
    }

    public static void fail(String message) {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        throw new SurefireAssertionFailedException(message);
    }

    public static void fail(String message, Throwable cause) {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is null");
        }
        throw new SurefireAssertionFailedException(message, cause);
    }

    public static void fail(Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("cause is null");
        }
        throw new SurefireAssertionFailedException(cause);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            SurefireAssert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        SurefireAssert.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        SurefireAssert.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        SurefireAssert.assertFalse(null, condition);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (!(expected == null && actual == null || expected != null && expected.equals(actual))) {
            SurefireAssert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        if (!(expected == null && actual == null || expected != null && expected.equals(actual))) {
            throw new SurefireComparisonFailureException(message, expected, actual);
        }
    }

    public static void assertEquals(String expected, String actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (!Double.isInfinite(actual)) {
                SurefireAssert.failNotEquals(message, new Double(expected), new Double(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            SurefireAssert.failNotEquals(message, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        SurefireAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (!Float.isInfinite(actual)) {
                SurefireAssert.failNotEquals(message, new Float(expected), new Float(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            SurefireAssert.failNotEquals(message, new Float(expected), new Float(actual));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        SurefireAssert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, long expected, long actual) {
        SurefireAssert.assertEquals(message, new Long(expected), new Long(actual));
    }

    public static void assertEquals(long expected, long actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        SurefireAssert.assertEquals(message, expected ? Boolean.TRUE : Boolean.FALSE, actual ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte expected, byte actual) {
        SurefireAssert.assertEquals(message, new Byte(expected), new Byte(actual));
    }

    public static void assertEquals(byte expected, byte actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char expected, char actual) {
        SurefireAssert.assertEquals(message, new Character(expected), new Character(actual));
    }

    public static void assertEquals(char expected, char actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, short expected, short actual) {
        SurefireAssert.assertEquals(message, new Short(expected), new Short(actual));
    }

    public static void assertEquals(short expected, short actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int expected, int actual) {
        SurefireAssert.assertEquals(message, new Integer(expected), new Integer(actual));
    }

    public static void assertEquals(int expected, int actual) {
        SurefireAssert.assertEquals(null, expected, actual);
    }

    public static void assertNotNull(Object object) {
        SurefireAssert.assertNotNull(null, object);
    }

    public static void assertNotNull(String message, Object object) {
        SurefireAssert.assertTrue(message, object != null);
    }

    public static void assertNull(Object object) {
        SurefireAssert.assertNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        SurefireAssert.assertTrue(message, object == null);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected != actual) {
            SurefireAssert.failNotSame(message, expected, actual);
        }
    }

    public static void assertSame(Object expected, Object actual) {
        SurefireAssert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            SurefireAssert.failSame(message);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        SurefireAssert.assertNotSame(null, expected, actual);
    }

    public static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        SurefireAssert.fail(formatted + "expected not same");
    }

    public static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        SurefireAssert.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    public static void failNotEquals(String message, Object expected, Object actual) {
        SurefireAssert.fail(SurefireAssert.formatMismatch(message, expected, actual));
    }

    static String formatMismatch(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

