/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;

public class IvyReport
extends IvyTask {
    private File _todir;
    private String _organisation;
    private String _module;
    private String _conf;
    private File _cache;
    private boolean _graph = true;
    private boolean _dot = false;
    private boolean _xml = false;
    private boolean _xsl = true;
    private String _xslFile;
    private String _outputpattern;
    private String _xslext = "html";
    private List _params = new ArrayList();

    public File getTodir() {
        return this._todir;
    }

    public void setTodir(File todir) {
        this._todir = todir;
    }

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getConf() {
        return this._conf;
    }

    public void setConf(String conf) {
        this._conf = conf;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public boolean isGraph() {
        return this._graph;
    }

    public void setGraph(boolean graph) {
        this._graph = graph;
    }

    public String getXslfile() {
        return this._xslFile;
    }

    public void setXslfile(String xslFile) {
        this._xslFile = xslFile;
    }

    public String getOutputpattern() {
        return this._outputpattern;
    }

    public void setOutputpattern(String outputpattern) {
        this._outputpattern = outputpattern;
    }

    public void execute() throws BuildException {
        String t;
        Ivy ivy = this.getIvyInstance();
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        this._conf = this.getProperty(this._conf, ivy, "ivy.resolved.configurations");
        if (this._conf.equals("*")) {
            this._conf = this.getProperty(ivy, "ivy.resolved.configurations");
        }
        if (this._conf == null) {
            throw new BuildException("no conf provided for ivy report task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        if (this._todir == null && (t = this.getProperty(ivy, "ivy.report.todir")) != null) {
            this._todir = new File(t);
        }
        this._outputpattern = this.getProperty(this._outputpattern, ivy, "ivy.report.output.pattern");
        if (this._todir != null && this._todir.exists()) {
            this._todir.mkdirs();
        }
        if (this._outputpattern == null) {
            this._outputpattern = "[organisation]-[module]-[conf].[ext]";
        }
        if (this._todir != null && this._todir.exists() && !this._todir.isDirectory()) {
            throw new BuildException("destination directory should be a directory !");
        }
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy report task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy report task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        try {
            String[] confs = this.splitConfs(this._conf);
            if (this._xsl) {
                this.genreport(this._cache, this._organisation, this._module, confs);
            }
            if (this._xml) {
                this.genxml(this._cache, this._organisation, this._module, confs);
            }
            if (this._graph) {
                this.genStyled(this._cache, this._organisation, this._module, confs, this.getStylePath(this._cache, "ivy-report-graph.xsl"), "graphml");
            }
            if (this._dot) {
                this.genStyled(this._cache, this._organisation, this._module, confs, this.getStylePath(this._cache, "ivy-report-dot.xsl"), "dot");
            }
        }
        catch (IOException e) {
            throw new BuildException("impossible to generate report: " + e, (Throwable)e);
        }
    }

    private void genxml(File cache, String organisation, String module, String[] confs) throws IOException {
        for (int i = 0; i < confs.length; ++i) {
            File xml = new File(cache, XmlReportOutputter.getReportFileName(new ModuleId(organisation, module), confs[i]));
            File out = this._todir != null ? new File(this._todir, IvyPatternHelper.substitute(this._outputpattern, organisation, module, "", "", "", "xml", confs[i])) : new File(IvyPatternHelper.substitute(this._outputpattern, organisation, module, "", "", "", "xml", confs[i]));
            FileUtil.copy(xml, out, null);
        }
    }

    private void genreport(File cache, String organisation, String module, String[] confs) throws IOException {
        this.genStyled(cache, organisation, module, confs, this.getReportStylePath(cache), this._xslext);
        if (this._todir != null && this._xslFile == null) {
            File css = new File(this._todir, "ivy-report.css");
            if (!css.exists()) {
                Message.debug("copying report css to " + this._todir);
                FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), css, null);
            }
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), new File(cache, "ivy-report.css"), null);
        }
    }

    private String getReportStylePath(File cache) throws IOException {
        if (this._xslFile != null) {
            return this._xslFile;
        }
        File style = new File(cache, "ivy-report.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.xsl"), style, null);
        return style.getAbsolutePath();
    }

    private void genStyled(File cache, String organisation, String module, String[] confs, String style, String ext) throws IOException {
        File out = this._todir != null ? this._todir : new File(".");
        XSLTProcess xslt = new XSLTProcess();
        xslt.setTaskName(this.getTaskName());
        xslt.setProject(this.getProject());
        xslt.init();
        xslt.setDestdir(out);
        xslt.setBasedir(cache);
        Mapper mapper = new Mapper(this.getProject());
        xslt.addMapper(mapper);
        for (int i = 0; i < confs.length; ++i) {
            String reportFileName = XmlReportOutputter.getReportFileName(new ModuleId(organisation, module), confs[i]);
            xslt.setIncludes(reportFileName);
            GlobPatternMapper reportMapper = new GlobPatternMapper();
            reportMapper.setFrom(reportFileName);
            reportMapper.setTo(IvyPatternHelper.substitute(this._outputpattern, organisation, module, "", "", "", ext, confs[i]));
            mapper.add((FileNameMapper)reportMapper);
        }
        xslt.setStyle(style);
        XSLTProcess.Param param = xslt.createParam();
        param.setName("confs");
        param.setExpression(this._conf);
        param = xslt.createParam();
        param.setName("extension");
        param.setExpression(this._xslext);
        Iterator it = this._params.iterator();
        while (it.hasNext()) {
            param = (XSLTProcess.Param)it.next();
            XSLTProcess.Param realParam = xslt.createParam();
            realParam.setName(param.getName());
            realParam.setExpression(param.getExpression());
        }
        xslt.execute();
    }

    private String getStylePath(File cache, String styleResourceName) throws IOException {
        File style = new File(cache, styleResourceName);
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream(styleResourceName), style, null);
        return style.getAbsolutePath();
    }

    public boolean isXml() {
        return this._xml;
    }

    public void setXml(boolean xml) {
        this._xml = xml;
    }

    public boolean isXsl() {
        return this._xsl;
    }

    public void setXsl(boolean xsl) {
        this._xsl = xsl;
    }

    public String getXslext() {
        return this._xslext;
    }

    public void setXslext(String xslext) {
        this._xslext = xslext;
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param result = new XSLTProcess.Param();
        this._params.add(result);
        return result;
    }

    public boolean isDot() {
        return this._dot;
    }

    public void setDot(boolean dot) {
        this._dot = dot;
    }
}

