/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.shared.xml.dom4j;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class DocumentLoader {
    private final Log log;

    public DocumentLoader(Log log) {
        this.log = log;
    }

    public Document loadDocument(File file) throws MojoExecutionException {
        String location = file.getAbsolutePath();
        try {
            ArrayList errors = new ArrayList();
            SAXReader saxReader = new SAXReader();
            saxReader.setErrorHandler((ErrorHandler)new ErrorLogger(location, errors, this.log));
            saxReader.setMergeAdjacentText(true);
            Document doc = saxReader.read(file);
            if (errors.size() != 0) {
                throw new MojoExecutionException("errors loading file [" + location + "]", (Throwable)errors.get(0));
            }
            return doc;
        }
        catch (DocumentException e) {
            throw new MojoExecutionException("errors loading file [" + location + "]", (Exception)((Object)e));
        }
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private final String file;
        private final List errors;
        private final Log log;

        public ErrorLogger(String file, List errors, Log log) {
            this.file = file;
            this.errors = errors;
            this.log = log;
        }

        public void error(SAXParseException error) {
            this.log.error((CharSequence)("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage()));
            this.errors.add(error);
        }

        public void fatalError(SAXParseException error) {
            this.error(error);
        }

        public void warning(SAXParseException warn) {
            this.log.warn((CharSequence)("Warning parsing XML: " + this.file + '(' + warn.getLineNumber() + ") " + warn.getMessage()));
        }
    }
}

