/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.DINameSpace;
import org.hsqldb.DITableInfo;
import org.hsqldb.DITypeInfo;
import org.hsqldb.Database;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.store.ValuePool;

class DatabaseInformationMain
extends DatabaseInformation {
    protected static final HsqlNameManager.HsqlName[] sysTableHsqlNames;
    protected final int[] sysTableSessions = new int[sysTableNames.length];
    protected final boolean[] sysTableSessionDependent = new boolean[sysTableNames.length];
    protected final Table[] sysTables = new Table[sysTableNames.length];
    protected static final HashSet nonCachedTablesSet;
    protected static final HashMap columnNameMap;
    protected Session session;
    protected static final String[] tableTypes;
    protected DINameSpace ns;

    static {
        tableTypes = new String[]{"GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW"};
        columnNameMap = new HashMap();
        nonCachedTablesSet = new HashSet();
        sysTableHsqlNames = new HsqlNameManager.HsqlName[sysTableNames.length];
        int i = 0;
        while (i < sysTableNames.length) {
            DatabaseInformationMain.sysTableHsqlNames[i] = HsqlNameManager.newHsqlSystemObjectName(sysTableNames[i]);
            DatabaseInformationMain.sysTableHsqlNames[i].schema = SchemaManager.INFORMATION_SCHEMA_HSQLNAME;
            ++i;
        }
        nonCachedTablesSet.add("SYSTEM_CACHEINFO");
        nonCachedTablesSet.add("SYSTEM_SESSIONINFO");
        nonCachedTablesSet.add("SYSTEM_SESSIONS");
        nonCachedTablesSet.add("SYSTEM_PROPERTIES");
        nonCachedTablesSet.add("SYSTEM_SEQUENCES");
    }

    DatabaseInformationMain(Database db) throws HsqlException {
        super(db);
        this.init();
    }

    protected final void addColumn(Table t, String name, int type, int size, boolean nullable) throws HsqlException {
        HsqlNameManager.HsqlName cn = (HsqlNameManager.HsqlName)columnNameMap.get(name);
        if (cn == null) {
            cn = this.database.nameManager.newHsqlName(name, false);
            columnNameMap.put(name, cn);
        }
        Column c = new Column(cn, nullable, type, size, 0, false, null);
        t.addColumn(c);
    }

    protected final void addColumn(Table t, String name, int type, boolean nullable) throws HsqlException {
        this.addColumn(t, name, type, 0, nullable);
    }

    protected final void addColumn(Table t, String name, int type) throws HsqlException {
        this.addColumn(t, name, type, true);
    }

    protected final Iterator allTables() {
        return new WrapperIterator(this.database.schemaManager.allTablesIterator(), new WrapperIterator(this.sysTables, true));
    }

    protected final void cacheClear() throws HsqlException {
        int i = this.sysTables.length;
        while (i-- > 0) {
            Table t = this.sysTables[i];
            if (t != null) {
                t.clearAllRows(this.session);
            }
            this.sysTableSessions[i] = -1;
        }
        this.isDirty = false;
    }

    protected Table generateTable(int tableIndex) throws HsqlException {
        Table cfr_ignored_0 = this.sysTables[tableIndex];
        switch (tableIndex) {
            case 0: {
                return this.SYSTEM_BESTROWIDENTIFIER();
            }
            case 1: {
                return this.SYSTEM_CATALOGS();
            }
            case 2: {
                return this.SYSTEM_COLUMNPRIVILEGES();
            }
            case 3: {
                return this.SYSTEM_COLUMNS();
            }
            case 4: {
                return this.SYSTEM_CROSSREFERENCE();
            }
            case 5: {
                return this.SYSTEM_INDEXINFO();
            }
            case 6: {
                return this.SYSTEM_PRIMARYKEYS();
            }
            case 7: {
                return this.SYSTEM_PROCEDURECOLUMNS();
            }
            case 8: {
                return this.SYSTEM_PROCEDURES();
            }
            case 9: {
                return this.SYSTEM_SCHEMAS();
            }
            case 12: {
                return this.SYSTEM_TABLEPRIVILEGES();
            }
            case 13: {
                return this.SYSTEM_TABLES();
            }
            case 14: {
                return this.SYSTEM_TABLETYPES();
            }
            case 15: {
                return this.SYSTEM_TYPEINFO();
            }
            case 18: {
                return this.SYSTEM_USERS();
            }
            case 29: {
                return this.SYSTEM_ALLTYPEINFO();
            }
            case 34: {
                return this.SYSTEM_CHECK_CONSTRAINTS();
            }
            case 32: {
                return this.SYSTEM_SEQUENCES();
            }
        }
        return null;
    }

    protected final void init() throws HsqlException {
        this.ns = new DINameSpace(this.database);
        this.sysTableSessionDependent[42] = true;
        this.sysTableSessionDependent[41] = true;
        this.sysTableSessionDependent[40] = true;
        this.sysTableSessionDependent[39] = true;
        this.sysTableSessionDependent[38] = true;
        this.sysTableSessionDependent[37] = true;
        this.sysTableSessionDependent[36] = true;
        this.sysTableSessionDependent[35] = true;
        this.sysTableSessionDependent[33] = true;
        this.sysTableSessionDependent[32] = true;
        this.sysTableSessionDependent[34] = true;
        this.sysTableSessionDependent[31] = true;
        this.sysTableSessionDependent[30] = true;
        this.sysTableSessionDependent[28] = true;
        this.sysTableSessionDependent[27] = true;
        this.sysTableSessionDependent[13] = true;
        this.sysTableSessionDependent[12] = true;
        this.sysTableSessionDependent[7] = true;
        this.sysTableSessionDependent[8] = true;
        this.sysTableSessionDependent[6] = true;
        this.sysTableSessionDependent[5] = true;
        this.sysTableSessionDependent[4] = true;
        this.sysTableSessionDependent[3] = true;
        this.sysTableSessionDependent[2] = true;
        this.sysTableSessionDependent[0] = true;
        this.sysTableSessionDependent[23] = true;
        this.sysTableSessionDependent[20] = true;
        int i = 0;
        while (i < this.sysTables.length) {
            this.sysTables[i] = this.generateTable(i);
            Table t = this.sysTables[i];
            if (t != null) {
                t.setDataReadOnly(true);
            }
            ++i;
        }
        GranteeManager gm = this.database.getGranteeManager();
        int i2 = 0;
        while (i2 < sysTableHsqlNames.length) {
            if (this.sysTables[i2] != null) {
                gm.grant("PUBLIC", sysTableHsqlNames[i2], 1);
            }
            ++i2;
        }
    }

    protected final boolean isAccessibleTable(Table table) throws HsqlException {
        return this.session.isAccessible(table.getName());
    }

    protected final Table createBlankTable(HsqlNameManager.HsqlName name) throws HsqlException {
        return new Table(this.database, name, 0);
    }

    final Table getSystemTable(Session session, String name) throws HsqlException {
        int oldSessionId;
        boolean tableValid;
        this.session = session;
        if (!this.isSystemTable(name)) {
            return null;
        }
        int tableIndex = DatabaseInformationMain.getSysTableID(name);
        Table t = this.sysTables[tableIndex];
        if (t == null) {
            return t;
        }
        if (!this.withContent) {
            return t;
        }
        if (this.isDirty) {
            this.cacheClear();
        }
        boolean bl = tableValid = (oldSessionId = this.sysTableSessions[tableIndex]) != -1;
        if (session.getId() != oldSessionId && this.sysTableSessionDependent[tableIndex]) {
            tableValid = false;
        }
        if (nonCachedTablesSet.contains(name)) {
            tableValid = false;
        }
        if (tableValid) {
            return t;
        }
        t.clearAllRows(session);
        this.sysTableSessions[tableIndex] = session.getId();
        t = this.generateTable(tableIndex);
        return t;
    }

    final Table SYSTEM_BESTROWIDENTIFIER() throws HsqlException {
        Table t = this.sysTables[0];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[0]);
            this.addColumn(t, "SCOPE", 5, false);
            this.addColumn(t, "COLUMN_NAME", 12, false);
            this.addColumn(t, "DATA_TYPE", 5, false);
            this.addColumn(t, "TYPE_NAME", 12, 32, false);
            this.addColumn(t, "COLUMN_SIZE", 4);
            this.addColumn(t, "BUFFER_LENGTH", 4);
            this.addColumn(t, "DECIMAL_DIGITS", 5);
            this.addColumn(t, "PSEUDO_COLUMN", 5, false);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "NULLABLE", 5, false);
            this.addColumn(t, "IN_KEY", 16, false);
            int[] nArray = new int[5];
            nArray[1] = 8;
            nArray[2] = 9;
            nArray[3] = 10;
            nArray[4] = 1;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        DITableInfo ti = new DITableInfo();
        HsqlDatabaseProperties p = this.database.getProperties();
        Iterator tables = p.isPropertyTrue("hsqldb.system_table_bri") ? this.allTables() : this.database.schemaManager.allTablesIterator();
        while (tables.hasNext()) {
            int[] cols;
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(table) || (cols = table.getBestRowIdentifiers()) == null) continue;
            ti.setTable(table);
            Boolean inKey = ValuePool.getBoolean(table.isBestRowIdentifiersStrict());
            String tableCatalog = this.ns.getCatalogName(table);
            String tableSchema = table.getSchemaName();
            String tableName = ti.getName();
            Integer scope = ti.getBRIScope();
            Integer pseudo = ti.getBRIPseudo();
            int i = 0;
            while (i < cols.length) {
                Object[] row = t.getEmptyRowData();
                row[0] = scope;
                row[1] = ti.getColName(i);
                row[2] = ti.getColDataType(i);
                row[3] = ti.getColDataTypeName(i);
                row[4] = ti.getColSize(i);
                row[5] = ti.getColBufLen(i);
                row[6] = ti.getColScale(i);
                row[7] = pseudo;
                row[8] = tableCatalog;
                row[9] = tableSchema;
                row[10] = tableName;
                row[11] = ti.getColNullability(i);
                row[12] = inKey;
                t.insertSys(row);
                ++i;
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_CATALOGS() throws HsqlException {
        Table t = this.sysTables[1];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[1]);
            this.addColumn(t, "TABLE_CAT", 12, false);
            t.createPrimaryKey(null, new int[1], true);
            return t;
        }
        Iterator catalogs = this.ns.iterateCatalogNames();
        while (catalogs.hasNext()) {
            Object[] row = t.getEmptyRowData();
            row[0] = (String)catalogs.next();
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_COLUMNPRIVILEGES() throws HsqlException {
        Table t = this.sysTables[2];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[2]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "COLUMN_NAME", 12, false);
            this.addColumn(t, "GRANTOR", 12, false);
            this.addColumn(t, "GRANTEE", 12, false);
            this.addColumn(t, "PRIVILEGE", 12, 10, false);
            this.addColumn(t, "IS_GRANTABLE", 12, 3, false);
            int[] nArray = new int[7];
            nArray[0] = 3;
            nArray[1] = 6;
            nArray[2] = 5;
            nArray[3] = 4;
            nArray[4] = 2;
            nArray[5] = 1;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        Result rs = this.session.sqlExecuteDirectNoPreChecks("select a.TABLE_CAT, a.TABLE_SCHEM, a.TABLE_NAME, b.COLUMN_NAME, a.GRANTOR, a.GRANTEE, a.PRIVILEGE, a.IS_GRANTABLE from  INFORMATION_SCHEMA.SYSTEM_TABLEPRIVILEGES a, INFORMATION_SCHEMA.SYSTEM_COLUMNS b where a.TABLE_NAME = b.TABLE_NAME and a.TABLE_SCHEM = b.TABLE_SCHEM;");
        t.insertSys(rs);
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_COLUMNS() throws HsqlException {
        Table t = this.sysTables[3];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[3]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "COLUMN_NAME", 12, false);
            this.addColumn(t, "DATA_TYPE", 5, false);
            this.addColumn(t, "TYPE_NAME", 12, 32, false);
            this.addColumn(t, "COLUMN_SIZE", 4);
            this.addColumn(t, "BUFFER_LENGTH", 4);
            this.addColumn(t, "DECIMAL_DIGITS", 4);
            this.addColumn(t, "NUM_PREC_RADIX", 4);
            this.addColumn(t, "NULLABLE", 4, false);
            this.addColumn(t, "REMARKS", 12);
            this.addColumn(t, "COLUMN_DEF", 12);
            this.addColumn(t, "SQL_DATA_TYPE", 4);
            this.addColumn(t, "SQL_DATETIME_SUB", 4);
            this.addColumn(t, "CHAR_OCTET_LENGTH", 4);
            this.addColumn(t, "ORDINAL_POSITION", 4, false);
            this.addColumn(t, "IS_NULLABLE", 12, 3, false);
            this.addColumn(t, "SCOPE_CATLOG", 12);
            this.addColumn(t, "SCOPE_SCHEMA", 12);
            this.addColumn(t, "SCOPE_TABLE", 12);
            this.addColumn(t, "SOURCE_DATA_TYPE", 12);
            this.addColumn(t, "TYPE_SUB", 4, false);
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[1] = 2;
            nArray[2] = 16;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        Iterator tables = this.allTables();
        DITableInfo ti = new DITableInfo();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(table)) continue;
            ti.setTable(table);
            String tableCatalog = this.ns.getCatalogName(table);
            String tableSchema = table.getSchemaName();
            String tableName = ti.getName();
            int columnCount = table.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                Object[] row = t.getEmptyRowData();
                row[0] = tableCatalog;
                row[1] = tableSchema;
                row[2] = tableName;
                row[3] = ti.getColName(i);
                row[4] = ti.getColDataType(i);
                row[5] = ti.getColDataTypeName(i);
                row[6] = ti.getColSize(i);
                row[7] = ti.getColBufLen(i);
                row[8] = ti.getColScale(i);
                row[9] = ti.getColPrecRadix(i);
                row[10] = ti.getColNullability(i);
                row[11] = ti.getColRemarks(i);
                row[12] = ti.getColDefault(i);
                row[13] = ti.getColSqlDataType(i);
                row[14] = ti.getColSqlDateTimeSub(i);
                row[15] = ti.getColCharOctLen(i);
                row[16] = ValuePool.getInt(i + 1);
                row[17] = ti.getColIsNullable(i);
                row[22] = ti.getColDataTypeSub(i);
                t.insertSys(row);
                ++i;
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_CROSSREFERENCE() throws HsqlException {
        Constraint constraint;
        int i;
        Table t = this.sysTables[4];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[4]);
            this.addColumn(t, "PKTABLE_CAT", 12);
            this.addColumn(t, "PKTABLE_SCHEM", 12);
            this.addColumn(t, "PKTABLE_NAME", 12, false);
            this.addColumn(t, "PKCOLUMN_NAME", 12, false);
            this.addColumn(t, "FKTABLE_CAT", 12);
            this.addColumn(t, "FKTABLE_SCHEM", 12);
            this.addColumn(t, "FKTABLE_NAME", 12, false);
            this.addColumn(t, "FKCOLUMN_NAME", 12, false);
            this.addColumn(t, "KEY_SEQ", 5, false);
            this.addColumn(t, "UPDATE_RULE", 5, false);
            this.addColumn(t, "DELETE_RULE", 5, false);
            this.addColumn(t, "FK_NAME", 12);
            this.addColumn(t, "PK_NAME", 12);
            this.addColumn(t, "DEFERRABILITY", 5, false);
            t.createPrimaryKey(null, new int[]{4, 5, 6, 8, 11}, false);
            return t;
        }
        Iterator tables = this.database.schemaManager.allTablesIterator();
        DITableInfo pkInfo = new DITableInfo();
        DITableInfo fkInfo = new DITableInfo();
        Integer deferrability = ValuePool.getInt(7);
        HsqlArrayList fkConstraintsList = new HsqlArrayList();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(table)) continue;
            Constraint[] constraints = table.getConstraints();
            int constraintCount = constraints.length;
            i = 0;
            while (i < constraintCount) {
                constraint = constraints[i];
                if (constraint.getType() == 0 && this.isAccessibleTable(constraint.getRef())) {
                    fkConstraintsList.add(constraint);
                }
                ++i;
            }
        }
        i = 0;
        while (i < fkConstraintsList.size()) {
            constraint = (Constraint)fkConstraintsList.get(i);
            Table pkTable = constraint.getMain();
            pkInfo.setTable(pkTable);
            String pkTableName = pkInfo.getName();
            Table fkTable = constraint.getRef();
            fkInfo.setTable(fkTable);
            String fkTableName = fkInfo.getName();
            String pkTableCatalog = this.ns.getCatalogName(pkTable);
            String pkTableSchema = pkTable.getSchemaName();
            String fkTableCatalog = this.ns.getCatalogName(fkTable);
            String fkTableSchema = fkTable.getSchemaName();
            int[] mainCols = constraint.getMainColumns();
            int[] refCols = constraint.getRefColumns();
            int columnCount = refCols.length;
            String fkName = constraint.getFkName();
            String pkName = constraint.getPkName();
            Integer deleteRule = ValuePool.getInt(constraint.getDeleteAction());
            Integer updateRule = ValuePool.getInt(constraint.getUpdateAction());
            int j = 0;
            while (j < columnCount) {
                Integer keySequence = ValuePool.getInt(j + 1);
                String pkColumnName = pkInfo.getColName(mainCols[j]);
                String fkColumnName = fkInfo.getColName(refCols[j]);
                Object[] row = t.getEmptyRowData();
                row[0] = pkTableCatalog;
                row[1] = pkTableSchema;
                row[2] = pkTableName;
                row[3] = pkColumnName;
                row[4] = fkTableCatalog;
                row[5] = fkTableSchema;
                row[6] = fkTableName;
                row[7] = fkColumnName;
                row[8] = keySequence;
                row[9] = updateRule;
                row[10] = deleteRule;
                row[11] = fkName;
                row[12] = pkName;
                row[13] = deferrability;
                t.insertSys(row);
                ++j;
            }
            ++i;
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_INDEXINFO() throws HsqlException {
        Table t = this.sysTables[5];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[5]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "NON_UNIQUE", 16, false);
            this.addColumn(t, "INDEX_QUALIFIER", 12);
            this.addColumn(t, "INDEX_NAME", 12);
            this.addColumn(t, "TYPE", 5, false);
            this.addColumn(t, "ORDINAL_POSITION", 5, false);
            this.addColumn(t, "COLUMN_NAME", 12);
            this.addColumn(t, "ASC_OR_DESC", 12, 1, true);
            this.addColumn(t, "CARDINALITY", 4);
            this.addColumn(t, "PAGES", 4);
            this.addColumn(t, "FILTER_CONDITION", 12);
            this.addColumn(t, "ROW_CARDINALITY", 4);
            t.createPrimaryKey(null, new int[]{3, 6, 5, 7, 4, 2}, false);
            return t;
        }
        DITableInfo ti = new DITableInfo();
        HsqlDatabaseProperties p = this.database.getProperties();
        Iterator tables = p.isPropertyTrue("hsqldb.system_table_indexinfo") ? this.allTables() : this.database.schemaManager.allTablesIterator();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(table)) continue;
            ti.setTable(table);
            String tableCatalog = this.ns.getCatalogName(table);
            String tableSchema = table.getSchemaName();
            String tableName = ti.getName();
            Object filterCondition = null;
            String indexQualifier = tableCatalog;
            int indexCount = table.getIndexCount();
            int i = 0;
            while (i < indexCount) {
                int colCount = ti.getIndexVisibleColumns(i);
                if (colCount >= 1) {
                    String indexName = ti.getIndexName(i);
                    Boolean nonUnique = ti.isIndexNonUnique(i);
                    Integer cardinality = ti.getIndexCardinality(i);
                    Integer pages = ValuePool.getInt(0);
                    Integer rowCardinality = ti.getIndexRowCardinality(i);
                    int[] cols = ti.getIndexColumns(i);
                    Integer indexType = ti.getIndexType(i);
                    int k = 0;
                    while (k < colCount) {
                        int col = cols[k];
                        Object[] row = t.getEmptyRowData();
                        row[0] = tableCatalog;
                        row[1] = tableSchema;
                        row[2] = tableName;
                        row[3] = nonUnique;
                        row[4] = indexQualifier;
                        row[5] = indexName;
                        row[6] = indexType;
                        row[7] = ValuePool.getInt(k + 1);
                        row[8] = ti.getColName(col);
                        row[9] = ti.getIndexColDirection(i, col);
                        row[10] = cardinality;
                        row[11] = pages;
                        row[13] = rowCardinality;
                        row[12] = filterCondition;
                        t.insertSys(row);
                        ++k;
                    }
                }
                ++i;
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_PRIMARYKEYS() throws HsqlException {
        Table t = this.sysTables[6];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[6]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "COLUMN_NAME", 12, false);
            this.addColumn(t, "KEY_SEQ", 5, false);
            this.addColumn(t, "PK_NAME", 12);
            int[] nArray = new int[4];
            nArray[0] = 3;
            nArray[1] = 2;
            nArray[2] = 1;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        HsqlDatabaseProperties p = this.database.getProperties();
        Iterator tables = p.isPropertyTrue("hsqldb.system_table_primarykeys") ? this.allTables() : this.database.schemaManager.allTablesIterator();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(table) || !table.hasPrimaryKey()) continue;
            Constraint constraint = table.getPrimaryConstraint();
            String tableCatalog = this.ns.getCatalogName(table);
            String tableSchema = table.getSchemaName();
            String tableName = table.getName().name;
            String primaryKeyName = constraint.getName().name;
            int[] cols = constraint.getMainColumns();
            int colCount = cols.length;
            int j = 0;
            while (j < colCount) {
                Object[] row = t.getEmptyRowData();
                row[0] = tableCatalog;
                row[1] = tableSchema;
                row[2] = tableName;
                row[3] = table.getColumn((int)cols[j]).columnName.name;
                row[4] = ValuePool.getInt(j + 1);
                row[5] = primaryKeyName;
                t.insertSys(row);
                ++j;
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_PROCEDURECOLUMNS() throws HsqlException {
        Table t = this.sysTables[7];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[7]);
            this.addColumn(t, "PROCEDURE_CAT", 12);
            this.addColumn(t, "PROCEDURE_SCHEM", 12);
            this.addColumn(t, "PROCEDURE_NAME", 12, false);
            this.addColumn(t, "COLUMN_NAME", 12, false);
            this.addColumn(t, "COLUMN_TYPE", 5, false);
            this.addColumn(t, "DATA_TYPE", 5, false);
            this.addColumn(t, "TYPE_NAME", 12, 32, false);
            this.addColumn(t, "PRECISION", 4);
            this.addColumn(t, "LENGTH", 4);
            this.addColumn(t, "SCALE", 5);
            this.addColumn(t, "RADIX", 5);
            this.addColumn(t, "NULLABLE", 5, false);
            this.addColumn(t, "REMARKS", 12);
            this.addColumn(t, "SPECIFIC_NAME", 12, false);
            this.addColumn(t, "SEQ", 4, false);
            int[] nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = 2;
            nArray[2] = 13;
            nArray[3] = 14;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_PROCEDURES() throws HsqlException {
        Table t = this.sysTables[8];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[8]);
            this.addColumn(t, "PROCEDURE_CAT", 12);
            this.addColumn(t, "PROCEDURE_SCHEM", 12);
            this.addColumn(t, "PROCEDURE_NAME", 12, false);
            this.addColumn(t, "NUM_INPUT_PARAMS", 4);
            this.addColumn(t, "NUM_OUTPUT_PARAMS", 4);
            this.addColumn(t, "NUM_RESULT_SETS", 4);
            this.addColumn(t, "REMARKS", 12);
            this.addColumn(t, "PROCEDURE_TYPE", 5, false);
            this.addColumn(t, "ORIGIN", 12, 32, false);
            this.addColumn(t, "SPECIFIC_NAME", 12, false);
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[1] = 2;
            nArray[2] = 9;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_SCHEMAS() throws HsqlException {
        Table t = this.sysTables[9];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[9]);
            this.addColumn(t, "TABLE_SCHEM", 12, false);
            this.addColumn(t, "TABLE_CATALOG", 12);
            this.addColumn(t, "IS_DEFAULT", 16);
            t.createPrimaryKey(null, new int[1], true);
            return t;
        }
        Iterator schemas = this.database.schemaManager.fullSchemaNamesIterator();
        String defschema = this.database.schemaManager.getDefaultSchemaName();
        while (schemas.hasNext()) {
            Object[] row = t.getEmptyRowData();
            String schema = (String)schemas.next();
            row[0] = schema;
            row[1] = this.ns.getCatalogName(row[0]);
            row[2] = schema.equals(defschema) ? Boolean.TRUE : Boolean.FALSE;
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_TABLEPRIVILEGES() throws HsqlException {
        Table t = this.sysTables[12];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[12]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "GRANTOR", 12, false);
            this.addColumn(t, "GRANTEE", 12, false);
            this.addColumn(t, "PRIVILEGE", 12, 10, false);
            this.addColumn(t, "IS_GRANTABLE", 12, 3, false);
            int[] nArray = new int[6];
            nArray[0] = 1;
            nArray[1] = 2;
            nArray[2] = 5;
            nArray[3] = 4;
            nArray[4] = 3;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        String grantorName = "DBA";
        HsqlArrayList users = this.database.getUserManager().listVisibleUsers(this.session, true);
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            HsqlNameManager.HsqlName accessKey = table.getName();
            if (!this.isAccessibleTable(table)) continue;
            String tableName = table.getName().name;
            String tableCatalog = this.ns.getCatalogName(table);
            String tableSchema = table.getSchemaName();
            int i = 0;
            while (i < users.size()) {
                User user = (User)users.get(i);
                String granteeName = user.getName();
                String[] tablePrivileges = user.isAdmin() ? UserManager.getRightsArray(15) : user.listGrantedTablePrivileges(accessKey);
                String isGrantable = user.isAdmin() ? "YES" : "NO";
                int j = 0;
                while (j < tablePrivileges.length) {
                    String privilege = tablePrivileges[j];
                    Object[] row = t.getEmptyRowData();
                    row[0] = tableCatalog;
                    row[1] = tableSchema;
                    row[2] = tableName;
                    row[3] = grantorName;
                    row[4] = granteeName;
                    row[5] = privilege;
                    row[6] = isGrantable;
                    t.insertSys(row);
                    ++j;
                }
                ++i;
            }
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_TABLES() throws HsqlException {
        Table t = this.sysTables[13];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[13]);
            this.addColumn(t, "TABLE_CAT", 12);
            this.addColumn(t, "TABLE_SCHEM", 12);
            this.addColumn(t, "TABLE_NAME", 12, false);
            this.addColumn(t, "TABLE_TYPE", 12, 16, false);
            this.addColumn(t, "REMARKS", 12);
            this.addColumn(t, "TYPE_CAT", 12);
            this.addColumn(t, "TYPE_SCHEM", 12);
            this.addColumn(t, "TYPE_NAME", 12);
            this.addColumn(t, "SELF_REFERENCING_COL_NAME", 12);
            this.addColumn(t, "REF_GENERATION", 12);
            this.addColumn(t, "HSQLDB_TYPE", 12, 6, true);
            this.addColumn(t, "READ_ONLY", 16, false);
            int[] nArray = new int[4];
            nArray[0] = 3;
            nArray[1] = 1;
            nArray[2] = 2;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        Iterator tables = this.allTables();
        DITableInfo ti = new DITableInfo();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(table)) continue;
            ti.setTable(table);
            Object[] row = t.getEmptyRowData();
            row[0] = this.ns.getCatalogName(table);
            row[1] = table.getSchemaName();
            row[2] = ti.getName();
            row[3] = ti.getStandardType();
            row[4] = ti.getRemark();
            row[10] = ti.getHsqlType();
            row[11] = ti.isReadOnly();
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_TABLETYPES() throws HsqlException {
        Table t = this.sysTables[14];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[14]);
            this.addColumn(t, "TABLE_TYPE", 12, 16, false);
            t.createPrimaryKey(null, new int[1], true);
            return t;
        }
        int i = 0;
        while (i < tableTypes.length) {
            Object[] row = t.getEmptyRowData();
            row[0] = tableTypes[i];
            t.insertSys(row);
            ++i;
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_TYPEINFO() throws HsqlException {
        Table t = this.sysTables[15];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[15]);
            this.addColumn(t, "TYPE_NAME", 12, 32, false);
            this.addColumn(t, "DATA_TYPE", 5, false);
            this.addColumn(t, "PRECISION", 4);
            this.addColumn(t, "LITERAL_PREFIX", 12, 2, true);
            this.addColumn(t, "LITERAL_SUFFIX", 12, 2, true);
            this.addColumn(t, "CREATE_PARAMS", 12);
            this.addColumn(t, "NULLABLE", 5);
            this.addColumn(t, "CASE_SENSITIVE", 16);
            this.addColumn(t, "SEARCHABLE", 5);
            this.addColumn(t, "UNSIGNED_ATTRIBUTE", 16);
            this.addColumn(t, "FIXED_PREC_SCALE", 16);
            this.addColumn(t, "AUTO_INCREMENT", 16);
            this.addColumn(t, "LOCAL_TYPE_NAME", 12);
            this.addColumn(t, "MINIMUM_SCALE", 5);
            this.addColumn(t, "MAXIMUM_SCALE", 5);
            this.addColumn(t, "SQL_DATA_TYPE", 4);
            this.addColumn(t, "SQL_DATETIME_SUB", 4);
            this.addColumn(t, "NUM_PREC_RADIX", 4);
            this.addColumn(t, "TYPE_SUB", 4);
            t.createPrimaryKey(null, new int[]{1, 18}, true);
            return t;
        }
        Result rs = this.session.sqlExecuteDirectNoPreChecks("select TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE,UNSIGNED_ATTRIBUTE, FIXED_PREC_SCALE, AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, SQL_DATA_TYPE, SQL_DATETIME_SUB, NUM_PREC_RADIX, TYPE_SUB from INFORMATION_SCHEMA.SYSTEM_ALLTYPEINFO  where AS_TAB_COL = true;");
        t.insertSys(rs);
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_ALLTYPEINFO() throws HsqlException {
        Table t = this.sysTables[29];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[29]);
            this.addColumn(t, "TYPE_NAME", 12, 32, false);
            this.addColumn(t, "DATA_TYPE", 5, false);
            this.addColumn(t, "PRECISION", 4);
            this.addColumn(t, "LITERAL_PREFIX", 12, 2, true);
            this.addColumn(t, "LITERAL_SUFFIX", 12, 2, true);
            this.addColumn(t, "CREATE_PARAMS", 12);
            this.addColumn(t, "NULLABLE", 5);
            this.addColumn(t, "CASE_SENSITIVE", 16);
            this.addColumn(t, "SEARCHABLE", 5);
            this.addColumn(t, "UNSIGNED_ATTRIBUTE", 16);
            this.addColumn(t, "FIXED_PREC_SCALE", 16);
            this.addColumn(t, "AUTO_INCREMENT", 16);
            this.addColumn(t, "LOCAL_TYPE_NAME", 12);
            this.addColumn(t, "MINIMUM_SCALE", 5);
            this.addColumn(t, "MAXIMUM_SCALE", 5);
            this.addColumn(t, "SQL_DATA_TYPE", 4);
            this.addColumn(t, "SQL_DATETIME_SUB", 4);
            this.addColumn(t, "NUM_PREC_RADIX", 4);
            this.addColumn(t, "INTERVAL_PRECISION", 4);
            this.addColumn(t, "AS_TAB_COL", 16);
            this.addColumn(t, "AS_PROC_COL", 16);
            this.addColumn(t, "MAX_PREC_ACT", -5);
            this.addColumn(t, "MIN_SCALE_ACT", 4);
            this.addColumn(t, "MAX_SCALE_ACT", 4);
            this.addColumn(t, "COL_ST_CLS_NAME", 12);
            this.addColumn(t, "COL_ST_IS_SUP", 16);
            this.addColumn(t, "STD_MAP_CLS_NAME", 12);
            this.addColumn(t, "STD_MAP_IS_SUP", 16);
            this.addColumn(t, "CST_MAP_CLS_NAME", 12);
            this.addColumn(t, "CST_MAP_IS_SUP", 16);
            this.addColumn(t, "MCOL_JDBC", 4);
            this.addColumn(t, "MCOL_ACT", -5);
            this.addColumn(t, "DEF_OR_FIXED_SCALE", 4);
            this.addColumn(t, "REMARKS", 12);
            this.addColumn(t, "TYPE_SUB", 4);
            t.createPrimaryKey(null, new int[]{1, 34}, true);
            return t;
        }
        DITypeInfo ti = new DITypeInfo();
        int i = 0;
        while (i < Types.ALL_TYPES.length) {
            ti.setTypeCode(Types.ALL_TYPES[i][0]);
            ti.setTypeSub(Types.ALL_TYPES[i][1]);
            Object[] row = t.getEmptyRowData();
            row[0] = ti.getTypeName();
            row[1] = ti.getDataType();
            row[2] = ti.getPrecision();
            row[3] = ti.getLiteralPrefix();
            row[4] = ti.getLiteralSuffix();
            row[5] = ti.getCreateParams();
            row[6] = ti.getNullability();
            row[7] = ti.isCaseSensitive();
            row[8] = ti.getSearchability();
            row[9] = ti.isUnsignedAttribute();
            row[10] = ti.isFixedPrecisionScale();
            row[11] = ti.isAutoIncrement();
            row[12] = ti.getLocalName();
            row[13] = ti.getMinScale();
            row[14] = ti.getMaxScale();
            row[15] = ti.getSqlDataType();
            row[16] = ti.getSqlDateTimeSub();
            row[17] = ti.getNumPrecRadix();
            row[18] = ti.getIntervalPrecision();
            row[19] = ti.isSupportedAsTCol();
            row[20] = ti.isSupportedAsPCol();
            row[21] = ti.getPrecisionAct();
            row[22] = ti.getMinScaleAct();
            row[23] = ti.getMaxScaleAct();
            row[24] = ti.getColStClsName();
            row[25] = ti.isColStClsSupported();
            row[26] = ti.getStdMapClsName();
            row[27] = ti.isStdMapClsSupported();
            row[28] = ti.getCstMapClsName();
            try {
                this.ns.classForName((String)row[28]);
                row[29] = Boolean.TRUE;
            }
            catch (Exception exception) {
                row[29] = Boolean.FALSE;
            }
            row[30] = ti.getCharOctLen();
            row[31] = ti.getCharOctLenAct();
            row[32] = ti.getDefaultScale();
            row[33] = ti.getRemarks();
            row[34] = ti.getDataTypeSub();
            t.insertSys(row);
            ++i;
        }
        t.setDataReadOnly(true);
        return t;
    }

    Table SYSTEM_USERS() throws HsqlException {
        Table t = this.sysTables[18];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[18]);
            this.addColumn(t, "USER", 12, false);
            this.addColumn(t, "ADMIN", 16, false);
            t.createPrimaryKey(null, new int[1], true);
            return t;
        }
        HsqlArrayList users = this.database.getUserManager().listVisibleUsers(this.session, false);
        int i = 0;
        while (i < users.size()) {
            Object[] row = t.getEmptyRowData();
            User user = (User)users.get(i);
            row[0] = user.getName();
            row[1] = ValuePool.getBoolean(user.isAdmin());
            t.insertSys(row);
            ++i;
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_CHECK_CONSTRAINTS() throws HsqlException {
        Constraint constraint;
        int i;
        Table table;
        Table t = this.sysTables[34];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[34]);
            this.addColumn(t, "CONSTRAINT_CATALOG", 12);
            this.addColumn(t, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(t, "CONSTRAINT_NAME", 12, false);
            this.addColumn(t, "CHECK_CLAUSE", 12, false);
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        Iterator tables = this.database.schemaManager.allTablesIterator();
        HsqlArrayList constraintList = new HsqlArrayList();
        while (tables.hasNext()) {
            table = (Table)tables.next();
            if (!this.isAccessibleTable(table)) continue;
            Constraint[] tableConstraints = table.getConstraints();
            int constraintCount = tableConstraints.length;
            i = 0;
            while (i < constraintCount) {
                constraint = tableConstraints[i];
                if (constraint.getType() == 3) {
                    constraintList.add(constraint);
                }
                ++i;
            }
        }
        i = 0;
        while (i < constraintList.size()) {
            Object[] row = t.getEmptyRowData();
            constraint = (Constraint)constraintList.get(i);
            table = constraint.getMain();
            row[0] = this.ns.getCatalogName(table);
            row[1] = table.getSchemaName();
            row[2] = constraint.constName.name;
            try {
                row[3] = constraint.core.check.getDDL();
            }
            catch (Exception exception) {}
            t.insertSys(row);
            ++i;
        }
        t.setDataReadOnly(true);
        return t;
    }

    final Table SYSTEM_SEQUENCES() throws HsqlException {
        Table t = this.sysTables[32];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[32]);
            this.addColumn(t, "SEQUENCE_CATALOG", 12);
            this.addColumn(t, "SEQUENCE_SCHEMA", 12);
            this.addColumn(t, "SEQUENCE_NAME", 12, true);
            this.addColumn(t, "DTD_IDENTIFIER", 12, true);
            this.addColumn(t, "MAXIMUM_VALUE", 12, 20, true);
            this.addColumn(t, "MINIMUM_VALUE", 12, 20, true);
            this.addColumn(t, "INCREMENT", 12, 20, true);
            this.addColumn(t, "CYCLE_OPTION", 12, 3, true);
            this.addColumn(t, "START_WITH", 12, 20, true);
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            t.createPrimaryKey(null, nArray, false);
            return t;
        }
        String min = ValuePool.getString("0");
        String intMax = ValuePool.getString(String.valueOf(Integer.MAX_VALUE));
        String longMax = String.valueOf(Long.MAX_VALUE);
        String cycleOption = ValuePool.getString("NO");
        Iterator it = this.database.schemaManager.allSequencesIterator();
        while (it.hasNext()) {
            Object[] row = t.getEmptyRowData();
            NumberSequence sequence = (NumberSequence)it.next();
            int dataType = sequence.getType();
            String sequenceName = sequence.getName().name;
            row[0] = this.ns.getCatalogName(sequence);
            row[1] = sequence.getSchemaName();
            row[2] = sequenceName;
            row[3] = Types.getTypeString(dataType);
            row[5] = min;
            row[6] = String.valueOf(sequence.getIncrement());
            row[7] = cycleOption;
            row[8] = String.valueOf(sequence.peek());
            switch (dataType) {
                case 4: {
                    row[4] = intMax;
                    break;
                }
                default: {
                    row[4] = longMax;
                }
            }
            t.insertSys(row);
        }
        t.setDataReadOnly(true);
        return t;
    }
}

