/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;

public class HsqlDateTime {
    private static Calendar today = new GregorianCalendar();
    private static Calendar tempCal = new GregorianCalendar();
    private static Calendar tempCalDefault = new GregorianCalendar();
    private static Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static java.sql.Date tempDate = new java.sql.Date(0L);
    private static java.sql.Date currentDate;
    static final String zerodatetime = "1970-01-01 00:00:00.000000000";
    static final String zeronanos = "000000000";
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    static SimpleDateFormat sdfd;
    static SimpleDateFormat sdft;
    static SimpleDateFormat sdfts;
    static SimpleDateFormat sdftsSys;
    private static Date sysDate;
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    public static final char e = '\uffff';

    static {
        HsqlDateTime.resetToday(System.currentTimeMillis());
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
        sdftsSys = new SimpleDateFormat(sdftsSysPattern);
        sysDate = new Date();
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'D'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}};
        javaDateTokens = new String[]{"yyyy", "yyyy", "yyyy", "yy", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "E", "w", "dd", "D", "k", "K", "K", "mm", "ss", "aaa", "aaa", "aaa", "aaa"};
    }

    public static Timestamp timestampValue(String s) throws HsqlException {
        if (s == null) {
            throw Trace.error(131);
        }
        if (s.length() > zerodatetime.length()) {
            throw Trace.error(124);
        }
        s = String.valueOf(s) + zerodatetime.substring(s.length());
        return Timestamp.valueOf(s);
    }

    public static Timestamp simpleTimestampValue(String s) {
        return Timestamp.valueOf(s);
    }

    public static Timestamp timestampValue(long time, int nano) {
        Timestamp ts = new Timestamp(time);
        ts.setNanos(nano);
        return ts;
    }

    public static java.sql.Date dateValue(String s) throws HsqlException {
        if (s == null) {
            throw Trace.error(131);
        }
        if (s.length() > sdfdPattern.length()) {
            s = s.substring(0, sdfdPattern.length());
        }
        return java.sql.Date.valueOf(s);
    }

    public static Time timeValue(String s) {
        if (s == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        return Time.valueOf(s);
    }

    static int compare(java.sql.Date a, java.sql.Date b) {
        long btime;
        long atime = a.getTime();
        if (atime == (btime = b.getTime())) {
            return 0;
        }
        return atime > btime ? 1 : -1;
    }

    static int compare(Time a, Time b) {
        long btime;
        long atime = a.getTime();
        if (atime == (btime = b.getTime())) {
            return 0;
        }
        return atime > btime ? 1 : -1;
    }

    static int compare(Timestamp a, Timestamp b) {
        long btime;
        long atime = a.getTime();
        if (atime == (btime = b.getTime())) {
            if (a.getNanos() == b.getNanos()) {
                return 0;
            }
            return a.getNanos() > b.getNanos() ? 1 : -1;
        }
        return atime > btime ? 1 : -1;
    }

    public static synchronized java.sql.Date getCurrentDate(long millis) {
        HsqlDateTime.getToday(millis);
        return currentDate;
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(Timestamp x) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(tempCalDefault);
            String n = String.valueOf(x.getNanos());
            return String.valueOf(sdfts.format(x)) + zeronanos.substring(n.length()) + n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(Timestamp x, Calendar cal) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(cal == null ? tempCalDefault : cal);
            String n = String.valueOf(x.getNanos());
            return String.valueOf(sdfts.format(x)) + zeronanos.substring(n.length()) + n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSytemTimeString() {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(System.currentTimeMillis());
            return sdftsSys.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long timestamp) {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(timestamp);
            return sdftsSys.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeString(Date x, Calendar cal) {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(cal == null ? tempCalDefault : cal);
            return sdft.format(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(Date x, Calendar cal) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(cal == null ? tempCalDefault : cal);
            return sdfd.format(x);
        }
    }

    static synchronized Calendar getToday(long millis) {
        if (millis - HsqlDateTime.getTimeInMillis(today) >= 86400000L) {
            HsqlDateTime.resetToday(millis);
        }
        return today;
    }

    public static void resetToDate(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static void resetToTime(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
    }

    private static synchronized void resetToday(long millis) {
        today.setTimeInMillis(millis);
        HsqlDateTime.resetToDate(today);
        currentDate = new java.sql.Date(HsqlDateTime.getTimeInMillis(today));
    }

    private static void setTimeInMillis(Calendar cal, long millis) {
        cal.setTimeInMillis(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimeInMillis(Date dt, Calendar source, Calendar target) {
        if (source == null) {
            source = tempCalDefault;
        }
        if (target == null) {
            target = tempCalDefault;
        }
        Calendar calendar = tempCal;
        synchronized (calendar) {
            tempCal.setTimeZone(source.getTimeZone());
            tempCal.setTime(dt);
            tempCal.setTimeZone(target.getTimeZone());
            return HsqlDateTime.getTimeInMillis(tempCal);
        }
    }

    public static long getTimeInMillis(Calendar cal) {
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(long t) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, t);
            HsqlDateTime.resetToTime(tempCalDefault);
            return HsqlDateTime.getTimeInMillis(tempCalDefault);
        }
    }

    public static Time getNormalisedTime(Time t) {
        return new Time(HsqlDateTime.getNormalisedTime(t.getTime()));
    }

    public static Time getNormalisedTime(Timestamp ts) {
        return new Time(HsqlDateTime.getNormalisedTime(ts.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long d) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, d);
            HsqlDateTime.resetToDate(tempCalDefault);
            return HsqlDateTime.getTimeInMillis(tempCalDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(Timestamp ts) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, ts.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(java.sql.Date d) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, d.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(Time t) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, System.currentTimeMillis());
            HsqlDateTime.resetToDate(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault) + t.getTime();
            return new Timestamp(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(java.sql.Date d) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, d.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new Timestamp(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDateTimePart(Date d, int part) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            tempCalDefault.setTime(d);
            return tempCalDefault.get(part);
        }
    }

    public static String toJavaDatePattern(String format) {
        int len = format.length();
        StringBuffer pattern = new StringBuffer(len);
        Tokenizer tokenizer = new Tokenizer();
        int i = 0;
        while (i <= len) {
            block6: {
                char ch;
                block5: {
                    char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
                    if (tokenizer.next(ch, dateTokens)) break block5;
                    int index = tokenizer.getLastMatch();
                    if (index >= 0) {
                        pattern.setLength(pattern.length() - tokenizer.length());
                        pattern.append(javaDateTokens[index]);
                    }
                    tokenizer.reset();
                    if (tokenizer.isConsumed()) break block6;
                }
                pattern.append(ch);
            }
            ++i;
        }
        pattern.setLength(pattern.length() - 1);
        return pattern.toString();
    }

    static class Tokenizer {
        private int last;
        private int offset;
        private long state;
        private boolean consumed;

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.last = -1;
            this.offset = -1;
            this.state = 0L;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.last;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        private boolean isZeroBit(int bit) {
            return (this.state & 1L << bit) == 0L;
        }

        private void setBit(int bit) {
            this.state |= 1L << bit;
        }

        public boolean next(char ch, char[][] tokens) {
            int index = ++this.offset;
            int len = this.offset + 1;
            int left = 0;
            this.consumed = false;
            int i = tokens.length;
            while (--i >= 0) {
                if (!this.isZeroBit(i)) continue;
                if (tokens[i][index] == ch) {
                    this.consumed = true;
                    if (tokens[i].length == len) {
                        this.setBit(i);
                        this.last = i;
                        continue;
                    }
                    ++left;
                    continue;
                }
                this.setBit(i);
            }
            return left > 0;
        }
    }
}

