/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;

final class TableFilter {
    static final int CONDITION_NONE = -1;
    static final int CONDITION_UNORDERED = 0;
    static final int CONDITION_START_END = 1;
    static final int CONDITION_START = 2;
    static final int CONDITION_END = 3;
    static final int CONDITION_OUTER = 4;
    Table filterTable;
    private String tableAlias;
    HashMappedList columnAliases;
    Index filterIndex;
    private Object[] emptyData;
    boolean[] usedColumns;
    private Expression eStart;
    private Expression eEnd;
    Expression eAnd;
    boolean isOuterJoin;
    boolean isAssigned;
    boolean isMultiFindFirst;
    Expression[] findFirstExpressions;
    private RowIterator it;
    Object[] currentData;
    Row currentRow;
    Object[] currentJoinData;
    boolean nonJoinIsNull;
    boolean isCurrentOuter;

    TableFilter(Table t, String alias, HashMappedList columnList, boolean outerjoin) {
        this.filterTable = t;
        this.tableAlias = alias == null ? t.getName().name : alias;
        this.columnAliases = columnList;
        this.isOuterJoin = outerjoin;
        this.emptyData = this.filterTable.getEmptyRowData();
        this.usedColumns = this.filterTable.getNewColumnCheckList();
    }

    String getName() {
        return this.tableAlias;
    }

    Table getTable() {
        return this.filterTable;
    }

    static int getConditionType(Expression e) {
        int exprType = e.getType();
        switch (exprType) {
            case 26: 
            case 27: {
                return 0;
            }
            case 30: {
                return e.isQueryCorrelated ? -1 : 0;
            }
            case 21: 
            case 34: {
                return 1;
            }
            case 22: 
            case 23: {
                return 2;
            }
            case 24: 
            case 25: {
                return 3;
            }
        }
        return -1;
    }

    void setConditions(Session session, Expression condition) throws HsqlException {
        this.setCondition(session, condition);
        if (this.filterIndex == null) {
            this.filterIndex = this.filterTable.getPrimaryIndex();
        }
        if (this.filterIndex.getVisibleColumns() == 1 || this.eStart == null || this.eAnd == null || this.eStart.exprType != 21) {
            return;
        }
        boolean[] check = this.filterTable.getNewColumnCheckList();
        Expression[] expr = new Expression[check.length];
        int colindex = this.eStart.getArg().getColumnNr();
        check[colindex] = true;
        expr[colindex] = this.eStart.getArg2();
        this.eAnd.getEquiJoinColumns(this, check, expr);
        if (ArrayUtil.containsAllTrueElements(check, this.filterIndex.colCheck)) {
            this.isMultiFindFirst = true;
            this.findFirstExpressions = expr;
        }
    }

    private void setCondition(Session session, Expression e) throws HsqlException {
        int type = e.getType();
        Expression e1 = e.getArg();
        Expression e2 = e.getArg2();
        this.isAssigned = true;
        if (type == 28) {
            this.setCondition(session, e1);
            this.setCondition(session, e2);
            return;
        }
        if (type == 29 && this.isOuterJoin && e.isInJoin && e.outerFilter == this) {
            this.addAndCondition(e);
            e.setTrue();
            return;
        }
        int conditionType = TableFilter.getConditionType(e);
        if (conditionType == -1) {
            return;
        }
        if (e1.getFilter() == this && e2.getFilter() == this) {
            conditionType = 0;
        } else if (e1.getFilter() == this) {
            if (!e.isInJoin && this.isOuterJoin) {
                return;
            }
        } else {
            if (e2.getFilter() == this && conditionType != 0) {
                e.swapCondition();
                this.setCondition(session, e);
                return;
            }
            if (e1.outerFilter == this) {
                conditionType = 4;
            } else {
                return;
            }
        }
        if (!e2.isResolved()) {
            return;
        }
        if (e1.outerFilter != null && e1.outerFilter != this) {
            return;
        }
        if (conditionType == 0) {
            this.addAndCondition(e);
            return;
        }
        if (conditionType == 4) {
            this.addAndCondition(e);
            return;
        }
        int i = e1.getColumnNr();
        Index index = this.filterTable.getIndexForColumn(session, i);
        if (index == null || this.filterIndex != index && this.filterIndex != null) {
            this.addAndCondition(e);
            return;
        }
        this.filterIndex = index;
        switch (conditionType) {
            case 1: {
                if (this.eStart != null || this.eEnd != null) {
                    this.addAndCondition(e);
                    return;
                }
                this.eEnd = this.eStart = new Expression(e);
                break;
            }
            case 2: {
                if (this.eStart != null) {
                    this.addAndCondition(e);
                    return;
                }
                this.eStart = new Expression(e);
                break;
            }
            case 3: {
                if (this.eEnd != null) {
                    this.addAndCondition(e);
                    return;
                }
                this.eEnd = new Expression(e);
            }
        }
        e.setTrue();
    }

    boolean findFirst(Session session) throws HsqlException {
        block10: {
            this.nonJoinIsNull = false;
            this.isCurrentOuter = false;
            if (this.filterIndex == null) {
                this.filterIndex = this.filterTable.getPrimaryIndex();
            }
            if (this.isMultiFindFirst) {
                boolean convertible = true;
                int[] types = this.filterTable.getColumnTypes();
                this.currentJoinData = this.filterTable.getEmptyRowData();
                int i = 0;
                while (i < this.findFirstExpressions.length) {
                    Expression e = this.findFirstExpressions[i];
                    if (e != null) {
                        Object value = e.getValue(session);
                        if (Column.compareToTypeRange(value, types[i]) != 0) {
                            convertible = false;
                            break;
                        }
                        value = Column.convertObject(value, types[i]);
                        this.currentJoinData[i] = e.getValue(session, types[i]);
                    }
                    ++i;
                }
                RowIterator rowIterator = this.it = convertible ? this.filterIndex.findFirstRow(session, this.currentJoinData) : this.filterIndex.emptyIterator();
                if (!this.it.hasNext()) {
                    ArrayUtil.clearArray(76, this.currentJoinData, 0, this.currentJoinData.length);
                }
            } else if (this.eStart == null) {
                this.it = this.eEnd == null ? this.filterIndex.firstRow(session) : this.filterIndex.findFirstRowNotNull(session);
            } else {
                Object value = this.eStart.getArg2().getValue(session);
                int valuetype = this.eStart.getArg2().getDataType();
                int targettype = this.eStart.getArg().getDataType();
                this.it = TableFilter.getFirstIterator(session, this.eStart.getType(), value, valuetype, this.filterIndex, targettype);
            }
            do {
                this.currentRow = this.it.next();
                if (this.currentRow == null) break block10;
                this.currentData = this.currentRow.getData();
                if (this.eEnd != null && !this.eEnd.testCondition(session)) break block10;
            } while (this.eAnd != null && !this.eAnd.testCondition(session));
            return true;
        }
        this.currentRow = null;
        this.currentData = this.emptyData;
        return false;
    }

    static RowIterator getFirstIterator(Session session, int eType, Object value, int valueType, Index index, int targetType) throws HsqlException {
        RowIterator it;
        int range = 0;
        if (targetType != valueType) {
            range = Column.compareToTypeRange(value, targetType);
        }
        if (range == 0) {
            value = Column.convertObject(value, targetType);
            it = index.findFirstRow(session, value, eType);
        } else {
            switch (eType) {
                case 22: 
                case 23: {
                    if (range < 0) {
                        it = index.findFirstRowNotNull(session);
                        break;
                    }
                }
                default: {
                    it = index.emptyIterator();
                }
            }
        }
        return it;
    }

    boolean next(Session session) throws HsqlException {
        boolean result;
        block2: {
            result = false;
            this.nonJoinIsNull = false;
            this.isCurrentOuter = false;
            do {
                this.currentRow = this.it.next();
                if (this.currentRow == null) break block2;
                this.currentData = this.currentRow.getData();
                if (this.eEnd != null && !this.eEnd.testCondition(session)) break block2;
            } while (this.eAnd != null && !this.eAnd.testCondition(session));
            result = true;
        }
        if (result) {
            return true;
        }
        this.currentRow = null;
        this.currentData = this.emptyData;
        return false;
    }

    boolean nextOuter(Session session) throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = true;
        this.currentData = this.emptyData;
        this.currentRow = null;
        return this.eAnd == null || this.eAnd.getFilter() != this && this.eAnd.isInJoin || this.eAnd.testCondition(session);
    }

    private void addAndCondition(Expression e) {
        Expression and;
        Expression e2 = new Expression(e);
        this.eAnd = this.eAnd == null ? e2 : (and = new Expression(28, this.eAnd, e2));
        e.setTrue();
    }

    void setAsCheckFilter() {
        this.filterIndex = null;
    }

    public String describe(Session session) {
        boolean fullScan;
        StringBuffer sb = new StringBuffer();
        Index index = this.filterIndex;
        Index primaryIndex = this.filterTable.getPrimaryIndex();
        int[] primaryKey = this.filterTable.getPrimaryKey();
        boolean hidden = false;
        boolean bl = fullScan = this.eStart == null && this.eEnd == null;
        if (index == null) {
            index = primaryIndex;
        }
        if (index == primaryIndex && primaryKey.length == 0) {
            hidden = true;
            fullScan = true;
        }
        sb.append(super.toString()).append('\n');
        sb.append("table=[").append(this.filterTable.getName().name).append("]\n");
        sb.append("alias=[").append(this.tableAlias).append("]\n");
        sb.append("access=[").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("]\n");
        sb.append("index=[");
        sb.append(index == null ? "NONE" : (index.getName() == null ? "UNNAMED" : index.getName().name));
        sb.append(hidden ? "[HIDDEN]]\n" : "]\n");
        sb.append("isOuterJoin=[").append(this.isOuterJoin).append("]\n");
        String temp = this.eStart == null ? "null" : this.eStart.describe(session);
        sb.append("eStart=[").append(temp).append("]\n");
        temp = this.eEnd == null ? "null" : this.eEnd.describe(session);
        sb.append("eEnd=[").append(temp).append("]\n");
        temp = this.eAnd == null ? "null" : this.eAnd.describe(session);
        sb.append("eAnd=[").append(temp).append("]");
        return sb.toString();
    }
}

