/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcBlob;
import org.hsqldb.jdbc.jdbcClob;
import org.hsqldb.jdbc.jdbcResultSetMetaData;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.AsciiStringInputStream;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class jdbcResultSet
implements ResultSet {
    boolean autoClose;
    public Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    int iColumnCount;
    private boolean bWasNull;
    private ResultSetMetaData rsmd;
    private HsqlProperties connProperties;
    private boolean isNetConn;
    jdbcStatement sqlStatement;
    int rsType = 1003;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;

    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null || this.rResult.isEmpty()) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = this.rResult.getSize() + 1;
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        this.iUpdateCount = -1;
        this.rResult = null;
        if (this.autoClose) {
            this.sqlStatement.close();
        }
    }

    public boolean wasNull() throws SQLException {
        return this.bWasNull;
    }

    public String getString(int columnIndex) throws SQLException {
        return (String)this.getColumnInType(columnIndex, 1);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 16);
        return o == null ? false : (Boolean)o;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, -6);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    public short getShort(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 5);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 4);
        return o == null ? 0 : ((Number)o).intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, -5);
        return o == null ? 0L : ((Number)o).longValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 7);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, 8);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bd = (BigDecimal)this.getColumnInType(columnIndex, 3);
        if (scale < 0) {
            throw Util.sqlException(62);
        }
        if (bd != null) {
            bd = bd.setScale(scale, 5);
        }
        return bd;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        Object x = this.getObject(columnIndex);
        if (x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof String) {
            return ((String)x).getBytes();
        }
        x = this.getColumnInType(columnIndex, -2);
        return (byte[])x;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getColumnInType(columnIndex, 91);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getColumnInType(columnIndex, 92);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getColumnInType(columnIndex, 93);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new AsciiStringInputStream(s);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringInputStream(s);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] b = this.getBytes(columnIndex);
        return this.wasNull() ? null : new ByteArrayInputStream(b);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        throw Util.notSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this, this.connProperties);
        }
        return this.rsmd;
    }

    public Object getObject(int columnIndex) throws SQLException {
        int t;
        Object o;
        this.checkAvailable();
        try {
            o = this.nCurrent.data[--columnIndex];
            t = this.rResult.metaData.colTypes[columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Util.sqlException(28, String.valueOf(++columnIndex));
        }
        if (this.checkNull(o)) {
            return null;
        }
        switch (t) {
            case 91: {
                return new Date(((Date)o).getTime());
            }
            case 92: {
                return new Time(((Time)o).getTime());
            }
            case 93: {
                long m = ((Timestamp)o).getTime();
                int n = ((Timestamp)o).getNanos();
                Timestamp ts = new Timestamp(m);
                ts.setNanos(n);
                return ts;
            }
            case 1111: 
            case 2000: {
                try {
                    return ((JavaObject)o).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw Util.sqlException(Trace.error(18));
                }
            }
            case -4: 
            case -3: 
            case -2: {
                return ((Binary)o).getClonedBytes();
            }
        }
        return o;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        int i = 0;
        while (i < this.iColumnCount) {
            String name = this.rResult.metaData.colLabels[i];
            if (columnName.equalsIgnoreCase(name)) {
                return i + 1;
            }
            ++i;
        }
        throw Util.sqlException(28, columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringReader(s);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getColumnInType(columnIndex, 3);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && !this.bInit;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && this.bInit && this.nCurrent == null;
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.iCurrentRow == 1;
    }

    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && this.bInit && this.nCurrent != null && this.nCurrent.next == null;
    }

    public void beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        this.bInit = false;
        this.nCurrent = null;
        this.iCurrentRow = 0;
    }

    public void afterLast() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult != null && this.rResult.rRoot != null) {
            this.bInit = true;
            this.iCurrentRow = this.rResult.getSize() + 1;
            this.nCurrent = null;
        }
    }

    public boolean first() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        this.bInit = false;
        if (this.rResult.rRoot != null) {
            this.bInit = true;
            this.nCurrent = this.rResult.rRoot;
            this.iCurrentRow = 1;
        }
        return this.bInit;
    }

    public boolean last() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (!this.bInit || this.nCurrent == null) {
            this.first();
        }
        while (this.nCurrent.next != null) {
            ++this.iCurrentRow;
            this.nCurrent = this.nCurrent.next;
        }
        return true;
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        return this.iCurrentRow;
    }

    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || row == 0) {
            return false;
        }
        switch (row) {
            case 1: {
                return this.first();
            }
            case -1: {
                return this.last();
            }
        }
        if (row < 0) {
            this.last();
            row = this.iCurrentRow + row + 1;
            if (row <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (row < this.iCurrentRow || this.iCurrentRow == 0) {
            this.beforeFirst();
        }
        while (row > this.iCurrentRow) {
            this.next();
            if (this.nCurrent == null) break;
        }
        return this.nCurrent != null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (rows >= 0) ** GOTO lbl16
        rows = this.iCurrentRow + rows;
        this.beforeFirst();
        if (rows > 0) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            this.next();
            if (this.nCurrent == null) break;
lbl16:
            // 3 sources

            ** while (rows-- > 0)
        }
lbl17:
        // 2 sources

        return this.nCurrent != null;
    }

    public boolean previous() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null || this.rResult.rRoot == null || this.iCurrentRow == 0) {
            return false;
        }
        if (this.bInit && this.nCurrent == null) {
            return this.last();
        }
        int targetRow = this.iCurrentRow - 1;
        if (targetRow == 0) {
            this.beforeFirst();
            return false;
        }
        this.first();
        while (targetRow != this.iCurrentRow) {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        return this.nCurrent != null;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (this.rsType == 1003 && direction != 1000) {
            throw Util.notSupported();
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw Util.sqlException(62);
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 1;
    }

    public int getType() throws SQLException {
        this.checkClosed();
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Util.notSupported();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Util.notSupported();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Util.notSupported();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw Util.notSupported();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        throw Util.notSupported();
    }

    public void updateRow() throws SQLException {
        throw Util.notSupported();
    }

    public void deleteRow() throws SQLException {
        throw Util.notSupported();
    }

    public void refreshRow() throws SQLException {
        throw Util.notSupported();
    }

    public void cancelRowUpdates() throws SQLException {
        throw Util.notSupported();
    }

    public void moveToInsertRow() throws SQLException {
        throw Util.notSupported();
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return this.sqlStatement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw Util.notSupported();
    }

    public Ref getRef(int i) throws SQLException {
        throw Util.notSupported();
    }

    public Blob getBlob(int i) throws SQLException {
        byte[] b = this.getBytes(i);
        return b == null ? null : new jdbcBlob(b);
    }

    public Clob getClob(int i) throws SQLException {
        String s = this.getString(i);
        return s == null ? null : new jdbcClob(s);
    }

    public Array getArray(int i) throws SQLException {
        throw Util.notSupported();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex);
        if (date == null) {
            return null;
        }
        if (cal == null) {
            return date;
        }
        cal.setTime(date);
        HsqlDateTime.resetToDate(cal);
        return new Date(cal.getTime().getTime());
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time t = this.getTime(columnIndex);
        if (t == null) {
            return null;
        }
        if (cal == null) {
            return t;
        }
        cal.setTime(t);
        HsqlDateTime.resetToTime(cal);
        return new Time(cal.getTime().getTime());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp ts = this.getTimestamp(columnIndex);
        if (cal != null && ts != null) {
            ts.setTime(HsqlDateTime.getTimeInMillis(ts, null, cal));
        }
        return ts;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    public URL getURL(String columnName) throws SQLException {
        throw Util.notSupported();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Util.notSupported();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw Util.notSupported();
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            throw Util.sqlException(35);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.rResult == null || this.sqlStatement != null && this.sqlStatement.isClosed) {
            throw Util.sqlException(158);
        }
    }

    void checkColumn(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.iColumnCount) {
            throw Util.sqlException(28, String.valueOf(columnIndex));
        }
    }

    private boolean checkNull(Object o) {
        if (o == null) {
            this.bWasNull = true;
            return true;
        }
        this.bWasNull = false;
        return false;
    }

    private Object getColumnInType(int columnIndex, int type) throws SQLException {
        Object o;
        int t;
        this.checkAvailable();
        try {
            t = this.rResult.metaData.colTypes[--columnIndex];
            o = this.nCurrent.data[columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Util.sqlException(28, String.valueOf(++columnIndex));
        }
        if (this.checkNull(o)) {
            return null;
        }
        if (t != type) {
            if (o instanceof Binary && type != 1) {
                throw Util.sqlException(16);
            }
            try {
                o = Column.convertObject(o, type);
            }
            catch (Exception exception) {
                String s = "type: " + Types.getTypeString(t) + " (" + t + ") expected: " + Types.getTypeString(type) + " value: " + o.toString();
                throw Util.sqlException(16, s);
            }
        }
        switch (type) {
            case 91: {
                return new Date(((Date)o).getTime());
            }
            case 92: {
                return new Time(((Time)o).getTime());
            }
            case 93: {
                long m = ((Timestamp)o).getTime();
                int n = ((Timestamp)o).getNanos();
                Timestamp ts = new Timestamp(m);
                ts.setNanos(n);
                return ts;
            }
        }
        return o;
    }

    jdbcResultSet(jdbcStatement s, Result r, HsqlProperties props, boolean isNetConnection) throws SQLException {
        this.sqlStatement = s;
        this.connProperties = props;
        this.isNetConn = isNetConnection;
        if (r.mode == 1) {
            this.iUpdateCount = r.getUpdateCount();
        } else if (r.isError()) {
            Util.throwError(r);
        } else {
            if (s != null) {
                this.rsType = s.rsType;
            }
            this.iUpdateCount = -1;
            this.rResult = r;
            this.iColumnCount = r.getColumnCount();
        }
        this.bWasNull = false;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }
}

