/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hsqldb.DatabaseURL;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.persist.HsqlProperties;

public class jdbcDriver
implements Driver {
    static {
        try {
            DriverManager.registerDriver(new jdbcDriver());
        }
        catch (Exception exception) {}
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return jdbcDriver.getConnection(url, info);
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        HsqlProperties props = DatabaseURL.parseURL(url, true);
        if (props == null) {
            throw new SQLException(Trace.getMessage(62));
        }
        if (props.isEmpty()) {
            return null;
        }
        props.addProperties(info);
        return new jdbcConnection(props);
    }

    public boolean acceptsURL(String url) {
        return url != null && url.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length());
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        String[] choices = new String[]{"true", "false"};
        DriverPropertyInfo[] pinfo = new DriverPropertyInfo[6];
        DriverPropertyInfo p = new DriverPropertyInfo("user", null);
        p.value = info.getProperty("user");
        p.required = true;
        pinfo[0] = p;
        p = new DriverPropertyInfo("password", null);
        p.value = info.getProperty("password");
        p.required = true;
        pinfo[1] = p;
        p = new DriverPropertyInfo("get_column_name", null);
        p.value = info.getProperty("get_column_name", "true");
        p.required = false;
        p.choices = choices;
        pinfo[2] = p;
        p = new DriverPropertyInfo("ifexists", null);
        p.value = info.getProperty("ifexists");
        p.required = false;
        p.choices = choices;
        pinfo[3] = p;
        p = new DriverPropertyInfo("default_schema", null);
        p.value = info.getProperty("default_schema");
        p.required = false;
        p.choices = choices;
        pinfo[4] = p;
        p = new DriverPropertyInfo("shutdown", null);
        p.value = info.getProperty("shutdown");
        p.required = false;
        p.choices = choices;
        pinfo[5] = p;
        return pinfo;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 8;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

