/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;

public class HsqlDeque
extends BaseList
implements HsqlList {
    private Object[] list = new Object[10];
    private int firstindex = 0;
    private int endindex = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;

    public int size() {
        return this.elementCount;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    public Object get(int i) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        return this.list[index];
    }

    public void add(int i, Object o) throws IndexOutOfBoundsException {
        throw new RuntimeException();
    }

    public Object set(int i, Object o) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        Object result = this.list[index];
        this.list[index] = o;
        return result;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        Object o = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return o;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        Object o = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return o;
    }

    public boolean add(Object o) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = o;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public boolean addLast(Object o) {
        return this.add(o);
    }

    public boolean addFirst(Object o) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = o;
        ++this.elementCount;
        return true;
    }

    public void clear() {
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = null;
            ++i;
        }
    }

    public Object remove(int index) {
        int target = this.getInternalIndex(index);
        Object value = this.list[target];
        if (target >= this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, target - this.firstindex);
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, target + 1, this.list, target, this.endindex - target - 1);
            this.list[this.endindex] = null;
            --this.endindex;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return value;
    }

    private int getInternalIndex(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int index = this.firstindex + i;
        if (index >= this.list.length) {
            index -= this.list.length;
        }
        return index;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        Object[] newList = new Object[this.list.length * 2];
        int i = 0;
        while (i < this.list.length) {
            newList[i] = this.list[i];
            ++i;
        }
        this.list = newList;
        newList = null;
        if (this.endindex <= this.firstindex) {
            int tail = this.firstindex + this.elementCount - this.endindex;
            int i2 = 0;
            while (i2 < this.endindex) {
                this.list[tail + i2] = this.list[i2];
                this.list[i2] = null;
                ++i2;
            }
            this.endindex = this.firstindex + this.elementCount;
        }
    }
}

