/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.scriptio.ScriptWriterBinary;

class ScriptWriterZipped
extends ScriptWriterBinary {
    private static final int bufferSize = 32768;

    ScriptWriterZipped(Database db, String file, boolean includeCached, boolean newFile) throws HsqlException {
        super(db, file, includeCached, newFile);
    }

    public void sync() {
    }

    protected void openFile() throws HsqlException {
        try {
            FileAccess fa = this.database.getFileAccess();
            OutputStream fos = fa.openOutputStreamElement(this.outFile);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = new DeflaterOutputStream(fos, new Deflater(-1), 32768);
        }
        catch (IOException e) {
            throw Trace.error(29, 115, new Object[]{e.toString(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
        ((DeflaterOutputStream)this.fileStreamOut).finish();
        this.fileStreamOut.flush();
    }
}

