/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.util.SqlTool;

public class SqlToolSprayer {
    public static String LS = System.getProperty("line.separator");
    private static String SYNTAX_MSG = "SYNTAX:  java [-D...] SqlToolSprayer 'SQL;' [urlid1 urlid2...]\nSystem properties you may use [default values]:\n    sqltoolsprayer.period (in ms.) [500]\n    sqltoolsprayer.maxtime (in ms.) [0]\n    sqltoolsprayer.monfile (filepath) [none]\n    sqltoolsprayer.rcfile (filepath) [none.  SqlTool default used.]\n    sqltoolsprayer.propfile (filepath) [none]";

    static {
        if (!LS.equals("\n")) {
            SYNTAX_MSG = SYNTAX_MSG.replaceAll("\n", LS);
        }
    }

    public static void main(String[] sa) {
        if (sa.length < 1) {
            System.err.println(SYNTAX_MSG);
            System.exit(4);
        }
        long period = System.getProperty("sqltoolsprayer.period") == null ? 500 : Integer.parseInt(System.getProperty("sqltoolsprayer.period"));
        long maxtime = System.getProperty("sqltoolsprayer.maxtime") == null ? 0 : Integer.parseInt(System.getProperty("sqltoolsprayer.maxtime"));
        String rcFile = System.getProperty("sqltoolsprayer.rcfile");
        String propfile = System.getProperty("sqltoolsprayer.propfile");
        File monitorFile = System.getProperty("sqltoolsprayer.monfile") == null ? null : new File(System.getProperty("sqltoolsprayer.monfile"));
        ArrayList<String> urlids = new ArrayList<String>();
        if (propfile != null) {
            try {
                SqlToolSprayer.getUrlsFromPropFile(propfile, urlids);
            }
            catch (Exception e) {
                System.err.println("Failed to load property file '" + propfile + "':  " + e);
                System.exit(3);
            }
        }
        int i = 1;
        while (i < sa.length) {
            urlids.add(sa[i]);
            ++i;
        }
        boolean[] status = new boolean[urlids.size()];
        int i2 = 0;
        while (i2 < status.length) {
            status[i2] = false;
            ++i2;
        }
        String[] stringArray = new String[5];
        stringArray[0] = "--sql";
        stringArray[1] = sa[0];
        stringArray[2] = "--rcfile";
        stringArray[3] = rcFile;
        String[] withRcArgs = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = "--sql";
        stringArray2[1] = sa[0];
        String[] withoutRcArgs = stringArray2;
        String[] sqlToolArgs = rcFile == null ? withoutRcArgs : withRcArgs;
        boolean onefailed = false;
        long startTime = new Date().getTime();
        while (true) {
            if (monitorFile != null && !monitorFile.exists()) {
                System.err.println("Required file is gone:  " + monitorFile);
                System.exit(2);
            }
            onefailed = false;
            int i3 = 0;
            while (i3 < status.length) {
                if (!status[i3]) {
                    sqlToolArgs[sqlToolArgs.length - 1] = (String)urlids.get(i3);
                    try {
                        new SqlTool();
                        SqlTool.objectMain(sqlToolArgs);
                        status[i3] = true;
                        System.err.println("Success for instance '" + urlids.get(i3) + "'");
                    }
                    catch (SqlTool.SqlToolException sqlToolException) {
                        onefailed = true;
                    }
                }
                ++i3;
            }
            if (!onefailed || maxtime == 0L || new Date().getTime() > startTime + maxtime) break;
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList failedUrlids = new ArrayList();
        int i4 = 0;
        while (i4 < status.length) {
            if (!status[i4]) {
                failedUrlids.add(urlids.get(i4));
            }
            ++i4;
        }
        if (failedUrlids.size() > 0) {
            System.err.println("Failed instances:   " + failedUrlids);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void getUrlsFromPropFile(String fileName, ArrayList al) throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream(fileName));
        int i = -1;
        String val;
        while ((val = p.getProperty("server.urlid." + ++i)) != null) {
            al.add(val);
        }
        return;
    }
}

