/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactRevisionId;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ant.IvyDeliver;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;

public class IvyPublish
extends IvyTask {
    private String _organisation;
    private String _module;
    private String _revision;
    private String _pubRevision;
    private File _cache;
    private String _srcivypattern;
    private String _status;
    private String _conf = null;
    private String _pubdate;
    private String _deliverTarget;
    private String _publishResolverName = null;
    private List _artifactspattern = new ArrayList();
    private File _deliveryList;
    private boolean _publishivy = true;
    private boolean _warnonmissing = true;
    private boolean _haltonmissing = true;
    private boolean _overwrite = false;
    private boolean _update = false;
    private boolean _replacedynamicrev = true;
    private boolean _forcedeliver;
    private Collection _artifacts = new ArrayList();

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getSrcivypattern() {
        return this._srcivypattern;
    }

    public void setSrcivypattern(String destivypattern) {
        this._srcivypattern = destivypattern;
    }

    public String getDeliverivypattern() {
        return this._srcivypattern;
    }

    public void setDeliverivypattern(String destivypattern) {
        this._srcivypattern = destivypattern;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public String getPubdate() {
        return this._pubdate;
    }

    public void setPubdate(String pubdate) {
        this._pubdate = pubdate;
    }

    public String getPubrevision() {
        return this._pubRevision;
    }

    public void setPubrevision(String pubRevision) {
        this._pubRevision = pubRevision;
    }

    public String getRevision() {
        return this._revision;
    }

    public void setRevision(String revision) {
        this._revision = revision;
    }

    public String getStatus() {
        return this._status;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void setConf(String conf) {
        this._conf = conf;
    }

    public void setDelivertarget(String deliverTarget) {
        this._deliverTarget = deliverTarget;
    }

    public void setDeliveryList(File deliveryList) {
        this._deliveryList = deliveryList;
    }

    public String getResolver() {
        return this._publishResolverName;
    }

    public void setResolver(String publishResolverName) {
        this._publishResolverName = publishResolverName;
    }

    public String getArtifactspattern() {
        return this._artifactspattern.isEmpty() ? null : this._artifactspattern.get(0);
    }

    public void setArtifactspattern(String artifactsPattern) {
        this._artifactspattern.clear();
        this._artifactspattern.add(artifactsPattern);
    }

    public void addArtifactspattern(String artifactsPattern) {
        this._artifactspattern.add(artifactsPattern);
    }

    public void addConfiguredArtifacts(ArtifactsPattern p) {
        this._artifactspattern.add(p.getPattern());
    }

    public boolean isReplacedynamicrev() {
        return this._replacedynamicrev;
    }

    public void setReplacedynamicrev(boolean replacedynamicrev) {
        this._replacedynamicrev = replacedynamicrev;
    }

    public void execute() throws BuildException {
        String p;
        Ivy ivy = this.getIvyInstance();
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        this._revision = this.getProperty(this._revision, ivy, "ivy.revision");
        this._pubRevision = this.getProperty(this._pubRevision, ivy, "ivy.deliver.revision");
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        if (this._artifactspattern.isEmpty() && (p = this.getProperty(null, ivy, "ivy.publish.src.artifacts.pattern")) != null) {
            this._artifactspattern.add(p);
        }
        if (this._srcivypattern == null) {
            this._srcivypattern = this.getArtifactspattern();
        }
        this._status = this.getProperty(this._status, ivy, "ivy.status");
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy publish task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy publish task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this._revision == null) {
            throw new BuildException("no module revision provided for ivy publish task: It can either be set explicitely via the attribute 'revision' or via 'ivy.revision' property or a prior call to <resolve/>");
        }
        if (this._artifactspattern.isEmpty()) {
            throw new BuildException("no artifacts pattern: either provide it through parameter or through ivy.publish.src.artifacts.pattern property");
        }
        if (this._publishResolverName == null) {
            throw new BuildException("no publish deliver name: please provide it through parameter 'resolver'");
        }
        if ("working".equals(this._revision)) {
            this._revision = "working@" + Ivy.getLocalHostName();
        }
        Date pubdate = this.getPubDate(this._pubdate, new Date());
        if (this._pubRevision == null) {
            this._pubRevision = this._revision.startsWith("working@") ? Ivy.DATE_FORMAT.format(pubdate) : this._revision;
        }
        if (this._status == null) {
            throw new BuildException("no status provided: either provide it as parameter or through the ivy.status.default property");
        }
        ModuleRevisionId mrid = ModuleRevisionId.newInstance(this._organisation, this._module, this._revision);
        try {
            File ivyFile = new File(IvyPatternHelper.substitute(this._srcivypattern, this._organisation, this._module, this._pubRevision, "ivy", "ivy", "xml"));
            if (null != this._conf && this.isPublishivy() && this.isPublishivy()) {
                Message.warn("Impossible to publish ivy file when conf is specified");
                Message.warn("Please, set publishivy to false");
                this.setPublishivy(false);
            }
            if (this._publishivy && (!ivyFile.exists() || this._forcedeliver)) {
                IvyDeliver deliver = new IvyDeliver();
                deliver.setProject(this.getProject());
                deliver.setCache(this.getCache());
                deliver.setDeliverpattern(this.getSrcivypattern());
                deliver.setDelivertarget(this._deliverTarget);
                deliver.setDeliveryList(this._deliveryList);
                deliver.setModule(this.getModule());
                deliver.setOrganisation(this.getOrganisation());
                deliver.setPubdate(Ivy.DATE_FORMAT.format(pubdate));
                deliver.setPubrevision(this.getPubrevision());
                deliver.setRevision(this.getRevision());
                deliver.setStatus(this.getStatus());
                deliver.setValidate(this.doValidate(ivy));
                deliver.setReplacedynamicrev(this.isReplacedynamicrev());
                deliver.execute();
            }
            Collection missing = ivy.publish(mrid, this._pubRevision, this._cache, this._artifactspattern, this._publishResolverName, this._publishivy ? this._srcivypattern : null, this.getStatus(), pubdate, this._artifacts.toArray(new Artifact[this._artifacts.size()]), this.doValidate(ivy), this._overwrite, this._update, this._conf);
            if (this._warnonmissing) {
                Iterator iter = missing.iterator();
                while (iter.hasNext()) {
                    Artifact artifact = (Artifact)iter.next();
                    Message.warn("missing artifact: " + artifact);
                }
            }
            if (this._haltonmissing && !missing.isEmpty()) {
                throw new BuildException("missing published artifacts for " + mrid + ": " + missing);
            }
        }
        catch (Exception e) {
            throw new BuildException("impossible to publish artifacts for " + mrid + ": " + e, (Throwable)e);
        }
    }

    public PublishArtifact createArtifact() {
        PublishArtifact art = new PublishArtifact();
        this._artifacts.add(art);
        return art;
    }

    public boolean isPublishivy() {
        return this._publishivy;
    }

    public void setPublishivy(boolean publishivy) {
        this._publishivy = publishivy;
    }

    public boolean isWarnonmissing() {
        return this._warnonmissing;
    }

    public void setWarnonmissing(boolean warnonmissing) {
        this._warnonmissing = warnonmissing;
    }

    public boolean isHaltonmissing() {
        return this._haltonmissing;
    }

    public void setHaltonmissing(boolean haltonmissing) {
        this._haltonmissing = haltonmissing;
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this._overwrite = overwrite;
    }

    public void setForcedeliver(boolean b) {
        this._forcedeliver = b;
    }

    public boolean isForcedeliver() {
        return this._forcedeliver;
    }

    public boolean isUpdate() {
        return this._update;
    }

    public void setUpdate(boolean update) {
        this._update = update;
    }

    public static class ArtifactsPattern {
        private String _pattern;

        public String getPattern() {
            return this._pattern;
        }

        public void setPattern(String pattern) {
            this._pattern = pattern;
        }
    }

    public class PublishArtifact
    implements Artifact {
        private String _ext;
        private String _name;
        private String _type;

        public String[] getConfigurations() {
            return null;
        }

        public String getExt() {
            return this._ext == null ? this._type : this._ext;
        }

        public ArtifactRevisionId getId() {
            return null;
        }

        public ModuleRevisionId getModuleRevisionId() {
            return null;
        }

        public String getName() {
            return this._name;
        }

        public Date getPublicationDate() {
            return null;
        }

        public String getType() {
            return this._type;
        }

        public URL getUrl() {
            return null;
        }

        public void setExt(String ext) {
            this._ext = ext;
        }

        public void setName(String name) {
            this._name = name;
        }

        public void setType(String type) {
            this._type = type;
        }

        public String getAttribute(String attName) {
            return null;
        }

        public Map getAttributes() {
            return new HashMap();
        }

        public String getExtraAttribute(String attName) {
            return null;
        }

        public Map getExtraAttributes() {
            return new HashMap();
        }

        public String getStandardAttribute(String attName) {
            return null;
        }

        public Map getStandardAttributes() {
            return new HashMap();
        }
    }
}

