/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.report;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.xml.XmlReportParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigurationResolveReport {
    private ModuleDescriptor _md;
    private String _conf;
    private Date _date;
    private Map _dependencyReports = new HashMap();
    private Map _dependencies = new LinkedHashMap();
    private Ivy _ivy;
    private Map _modulesIdsMap = new LinkedHashMap();
    private List _modulesIds;
    private List _previousDeps;

    public ConfigurationResolveReport(Ivy ivy, ModuleDescriptor md, String conf, Date date, File cache) {
        this._ivy = ivy;
        this._md = md;
        this._conf = conf;
        this._date = date;
        File previousReportFile = new File(cache, XmlReportOutputter.getReportFileName(md.getModuleRevisionId().getModuleId(), conf));
        if (previousReportFile.exists()) {
            try {
                this._previousDeps = Arrays.asList(new XmlReportParser().getDependencyRevisionIds(md.getModuleRevisionId().getModuleId(), conf, cache));
            }
            catch (Exception e) {
                this._previousDeps = null;
            }
        } else {
            this._previousDeps = null;
        }
    }

    public boolean hasChanged() {
        if (this._previousDeps == null) {
            return true;
        }
        return !new HashSet(this._previousDeps).equals(this.getModuleRevisionIds());
    }

    public Set getModuleRevisionIds() {
        LinkedHashSet<ModuleRevisionId> mrids = new LinkedHashSet<ModuleRevisionId>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (node.isEvicted(this.getConfiguration()) || node.hasProblem()) continue;
            mrids.add(node.getResolvedId());
        }
        return mrids;
    }

    public void addDependency(IvyNode node) {
        this._dependencies.put(node.getId(), node);
        this._dependencies.put(node.getResolvedId(), node);
        this._dependencyReports.put(node, Collections.EMPTY_LIST);
    }

    public void addDependency(IvyNode node, DownloadReport report) {
        this._dependencies.put(node.getId(), node);
        this._dependencies.put(node.getResolvedId(), node);
        ArrayList<ArtifactDownloadReport> adrs = new ArrayList<ArtifactDownloadReport>();
        Artifact[] artifacts = node.getArtifacts(this._conf);
        for (int i = 0; i < artifacts.length; ++i) {
            ArtifactDownloadReport artifactReport = report.getArtifactReport(artifacts[i]);
            if (artifactReport != null) {
                adrs.add(artifactReport);
                continue;
            }
            Message.debug("no report found for " + artifacts[i]);
        }
        this._dependencyReports.put(node, adrs);
    }

    public String getConfiguration() {
        return this._conf;
    }

    public Date getDate() {
        return this._date;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this._md;
    }

    public IvyNode[] getUnresolvedDependencies() {
        ArrayList<IvyNode> unresolved = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.hasProblem()) continue;
            unresolved.add(node);
        }
        return unresolved.toArray(new IvyNode[unresolved.size()]);
    }

    private Collection getDependencies() {
        return new LinkedHashSet(this._dependencies.values());
    }

    public IvyNode[] getEvictedNodes() {
        ArrayList<IvyNode> evicted = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.isEvicted(this._conf)) continue;
            evicted.add(node);
        }
        return evicted.toArray(new IvyNode[evicted.size()]);
    }

    public IvyNode[] getDownloadedNodes() {
        ArrayList<IvyNode> downloaded = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.isDownloaded() || node.getRealNode() != node) continue;
            downloaded.add(node);
        }
        return downloaded.toArray(new IvyNode[downloaded.size()]);
    }

    public IvyNode[] getSearchedNodes() {
        ArrayList<IvyNode> downloaded = new ArrayList<IvyNode>();
        Iterator iter = this.getDependencies().iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.isSearched() || node.getRealNode() != node) continue;
            downloaded.add(node);
        }
        return downloaded.toArray(new IvyNode[downloaded.size()]);
    }

    public ArtifactDownloadReport[] getDownloadReports(ModuleRevisionId mrid) {
        Collection col = (Collection)this._dependencyReports.get(this.getDependency(mrid));
        if (col == null) {
            return new ArtifactDownloadReport[0];
        }
        return col.toArray(new ArtifactDownloadReport[col.size()]);
    }

    public IvyNode getDependency(ModuleRevisionId mrid) {
        return (IvyNode)this._dependencies.get(mrid);
    }

    public List getModuleIds() {
        if (this._modulesIds == null) {
            List sortedDependencies = this._ivy.sortNodes(this.getDependencies());
            Collections.reverse(sortedDependencies);
            Iterator iter = sortedDependencies.iterator();
            while (iter.hasNext()) {
                IvyNode dependency = (IvyNode)iter.next();
                ModuleId mid = dependency.getResolvedId().getModuleId();
                HashSet<IvyNode> deps = (HashSet<IvyNode>)this._modulesIdsMap.get(mid);
                if (deps == null) {
                    deps = new HashSet<IvyNode>();
                    this._modulesIdsMap.put(mid, deps);
                }
                deps.add(dependency);
            }
            this._modulesIds = new ArrayList(this._modulesIdsMap.keySet());
        }
        return Collections.unmodifiableList(this._modulesIds);
    }

    public Collection getNodes(ModuleId mid) {
        if (this._modulesIds == null) {
            this.getModuleIds();
        }
        return (Collection)this._modulesIdsMap.get(mid);
    }

    public Ivy getIvy() {
        return this._ivy;
    }

    public int getArtifactsNumber() {
        int total = 0;
        Iterator iter = this._dependencyReports.values().iterator();
        while (iter.hasNext()) {
            Collection reports = (Collection)iter.next();
            total += reports == null ? 0 : reports.size();
        }
        return total;
    }

    public ArtifactDownloadReport[] getDownloadedArtifactsReports() {
        ArrayList<ArtifactDownloadReport> result = new ArrayList<ArtifactDownloadReport>();
        Iterator iter = this._dependencyReports.values().iterator();
        while (iter.hasNext()) {
            Collection reports = (Collection)iter.next();
            Iterator iterator = reports.iterator();
            while (iterator.hasNext()) {
                ArtifactDownloadReport adr = (ArtifactDownloadReport)iterator.next();
                if (adr.getDownloadStatus() != DownloadStatus.SUCCESSFUL) continue;
                result.add(adr);
            }
        }
        return result.toArray(new ArtifactDownloadReport[result.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        ArrayList<ArtifactDownloadReport> result = new ArrayList<ArtifactDownloadReport>();
        Iterator iter = this._dependencyReports.values().iterator();
        while (iter.hasNext()) {
            Collection reports = (Collection)iter.next();
            Iterator iterator = reports.iterator();
            while (iterator.hasNext()) {
                ArtifactDownloadReport adr = (ArtifactDownloadReport)iterator.next();
                if (adr.getDownloadStatus() != DownloadStatus.FAILED) continue;
                result.add(adr);
            }
        }
        return result.toArray(new ArtifactDownloadReport[result.size()]);
    }

    public boolean hasError() {
        return this.getUnresolvedDependencies().length > 0 || this.getFailedArtifactsReports().length > 0;
    }

    public int getNodesNumber() {
        return this.getDependencies().size();
    }
}

