//$Id: OtherLogListener.java 19092 2010-03-23 21:14:04Z stliu $
package org.hibernate.test.annotations.reflection;

import javax.persistence.PostPersist;
import javax.persistence.PrePersist;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author Emmanuel Bernard
 */
public class OtherLogListener {
	private final Logger log = LoggerFactory.getLogger( OtherLogListener.class );

	@PrePersist
	@PostPersist
	public void log(Object entity) {
		log.debug( "Logging entity {} with hashCode: {}", entity.getClass().getName(), entity.hashCode() );
	}


	public void noLog(Object entity) {
		log.debug( "NoLogging entity {} with hashCode: {}", entity.getClass().getName(), entity.hashCode() );
	}
}
