//$Id: BlobTest.java 19416 2010-05-08 06:11:23Z stliu $
package org.hibernate.ejb.test.lob;

import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManager;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.ejb.test.TestCase;

/**
 * @author Emmanuel Bernard
 */
public class BlobTest extends TestCase {

	public void testBlobSerialization() throws Exception {
		EntityManager em = getOrCreateEntityManager();
		em.getTransaction().begin();
		Map image = new HashMap();
		image.put( "meta", "metadata" );
		image.put( "data", "imagedata" );
		ImageReader reader = new ImageReader();
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ObjectOutputStream oos = new ObjectOutputStream( baos );
		oos.writeObject( image );
		reader.setImage( Hibernate.createBlob( baos.toByteArray(), ((HibernateEntityManager)em).getSession() ) );
		em.persist( reader );
		em.getTransaction().commit();
		em.close(); //useless but y'a know
		em = getOrCreateEntityManager();
		em.getTransaction().begin();
		reader = em.find( ImageReader.class, reader.getId() );
		ObjectInputStream ois = new ObjectInputStream( reader.getImage().getBinaryStream() );
		image = (HashMap) ois.readObject();
		assertTrue( image.containsKey( "meta" ) );
		em.getTransaction().commit();
		em.close();
	}
	
	@Override
	protected boolean runForCurrentDialect( Dialect dialect ) {
		return dialect.supportsExpectedLobUsagePattern();
	}

	public Class[] getAnnotatedClasses() {
		return new Class[]{
				ImageReader.class
		};
	}
}
