/*
 * JBoss, Home of Professional Open Source
 * Copyright XXXX, Red Hat Middleware LLC, and individual contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a full listing
 * of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License, v. 2.0.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License,
 * v. 2.0 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * 
 * @author amit bhayani
 * 
 */
public class RTPSampleConstructor extends RTPConstructor {

	public static final int TYPE = 2;

	private byte trackRefIndex;
	private int length;
	private long sampleNumber;
	private long sampleOffSet;
	private int bytesPerBlock = 1;
	private int samplesPerBlock = 1;

	public RTPSampleConstructor() {
		super(TYPE);
	}

	@Override
	public int load(RandomAccessFile raAccFile) throws IOException {
		trackRefIndex = raAccFile.readByte();
		length = (raAccFile.read() << 8) | raAccFile.read();
		sampleNumber = ((long) (raAccFile.read() << 24 | raAccFile.read() << 16 | raAccFile.read() << 8 | raAccFile
				.read())) & 0xFFFFFFFFL;

		sampleOffSet = ((long) (raAccFile.read() << 24 | raAccFile.read() << 16 | raAccFile.read() << 8 | raAccFile
				.read())) & 0xFFFFFFFFL;

		bytesPerBlock = (raAccFile.read() << 8) | raAccFile.read();

		samplesPerBlock = (raAccFile.read() << 8) | raAccFile.read();

		return 16;
	}

	public int getTrackRefIndex() {
		return trackRefIndex;
	}

	public int getLength() {
		return length;
	}

	public long getSampleNumber() {
		return sampleNumber;
	}

	public long getSampleOffSet() {
		return sampleOffSet;
	}

	public int getBytesPerBlock() {
		return bytesPerBlock;
	}

	public int getSamplesPerBlock() {
		return samplesPerBlock;
	}

}
