/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

/**
 * 
 */
package org.mobicents.protocols.ss7.tcap.tc.dialog.events;

import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.EventType;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;

/**
 * @author baranowb
 *
 */
public class TCPAbortIndicationImpl extends DialogIndicationImpl implements TCPAbortIndication {
	//This indication is used to inform user of abnormal cases.
	private PAbortCauseType cause;
	
	TCPAbortIndicationImpl() {
		super(EventType.PAbort);
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication#getPAbortCause()
	 */
	public PAbortCauseType getPAbortCause() {
		return this.cause;
	}

	/* (non-Javadoc)
	 * @see org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication#setPAbortCause(org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType)
	 */
	public void setPAbortCause(PAbortCauseType t) {
		this.cause = t;

	}

}
