/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.diameter.stack.management;

import java.io.Serializable;

public class DiameterStatistic implements Serializable {

  private static final long serialVersionUID = 1L;

  private String name;
  private String description;
  private String value;

  public DiameterStatistic(String name, String description, String value) {
    super();
    this.name = name;
    this.description = description;
    this.value = value;
  }

  public String getName() {
    return name;
  }
  
  public String getDescription() {
    return description;
  }
  
  public Object getValue() {
    return this.value.indexOf('.') != -1 ? Double.valueOf(value) : Long.valueOf(value);
  }
  
  public String getValueAsString() {
    return value;
  }
  
  @Override
  public String toString() {
    return name + "=" + value;
  }
}
