/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.media.server.impl.resource.test;

import org.mobicents.media.Component;
import org.mobicents.media.ComponentFactory;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.ResourceUnavailableException;

/**
 *
 * @author kulikov
 */
public class SineGeneratorFactory implements ComponentFactory {

    private String name;
    private int f;
    private short A;

    public short getA() {
        return A;
    }

    public int getF() {
        return f;
    }

    public String getName() {
        return name;
    }

    public void setA(short A) {
        this.A = A;
    }

    public void setF(int f) {
        this.f = f;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    
    public Component newInstance(Endpoint endpoint) throws ResourceUnavailableException {
        SineGenerator gen = new SineGenerator(endpoint, name);
        gen.setAmplitude(A);
        gen.setFrequency(f);
        return gen;
    }

}
