/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.odata4j.core.ImmutableList;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmType;

public class EdmFunctionParameter
extends EdmItem {
    private final String name;
    private final EdmType type;
    private final Mode mode;
    private final Boolean nullable;
    private final Integer maxLength;
    private final Integer precision;
    private final Integer scale;

    private EdmFunctionParameter(String name, EdmType type, Mode mode, Boolean nullable, Integer maxLength, Integer precision, Integer scale, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots, ImmutableList<EdmAnnotation<?>> annotElements) {
        super(doc, annots, annotElements);
        this.name = name;
        this.type = type;
        this.mode = mode;
        this.nullable = nullable;
        this.maxLength = maxLength;
        this.precision = precision;
        this.scale = scale;
    }

    public String getName() {
        return this.name;
    }

    public EdmType getType() {
        return this.type;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(EdmFunctionParameter functionParameter, EdmItem.BuilderContext context) {
        return context.newBuilder(functionParameter, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmFunctionParameter, Builder> {
        private String name;
        private EdmType type;
        private EdmType.Builder<?, ?> typeBuilder;
        private Mode mode;
        private Boolean nullable;
        private Integer maxLength;
        private Integer precision;
        private Integer scale;

        @Override
        Builder newBuilder(EdmFunctionParameter functionParameter, EdmItem.BuilderContext context) {
            return new Builder().setName(functionParameter.name).setType(functionParameter.type).setMode(functionParameter.mode);
        }

        public EdmFunctionParameter build() {
            return new EdmFunctionParameter(this.name, this.typeBuilder != null ? this.typeBuilder.build() : this.type, this.mode, this.nullable, this.maxLength, this.precision, this.scale, this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()), ImmutableList.copyOf(this.getAnnotationElements()));
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(EdmType type) {
            this.type = type;
            return this;
        }

        public Builder setType(EdmType.Builder<?, ?> typeBuilder) {
            this.typeBuilder = typeBuilder;
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setNullable(Boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder setPrecision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public Builder setScale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public Builder input(String name, EdmType type) {
            this.mode = Mode.In;
            this.name = name;
            this.type = type;
            return this;
        }
    }

    public static enum Mode {
        In,
        Out,
        InOut;

    }
}

