/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.Reader;
import java.util.Stack;
import org.odata4j.format.json.JsonEndPropertyEventImpl;
import org.odata4j.format.json.JsonEventImpl;
import org.odata4j.format.json.JsonStartPropertyEventImpl;
import org.odata4j.format.json.JsonStreamReaderFactory;
import org.odata4j.format.json.JsonStreamTokenizerImpl;
import org.odata4j.format.json.JsonValueEventImpl;
import org.odata4j.format.json.ReaderState;

class JsonStreamReaderImpl
implements JsonStreamReaderFactory.JsonStreamReader {
    private static final boolean DUMP = false;
    private JsonStreamTokenizerImpl tokenizer;
    private Stack<ReaderState> state = new Stack();
    private Stack<Boolean> expectCommaOrEndStack = new Stack();
    private boolean expectCommaOrEnd;
    private boolean fireEndPropertyEvent;
    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent previousEvent = null;

    private static void dump(String msg) {
    }

    JsonStreamReaderImpl(Reader reader) {
        this.state.push(ReaderState.NONE);
        this.tokenizer = new JsonStreamTokenizerImpl(reader);
    }

    @Override
    public boolean hasNext() {
        return this.tokenizer.hasNext();
    }

    @Override
    public JsonStreamReaderFactory.JsonStreamReader.JsonEvent nextEvent() {
        if (this.fireEndPropertyEvent) {
            if (this.state.peek() != ReaderState.PROPERTY) {
                throw new IllegalStateException("State is " + (Object)((Object)this.state.peek()));
            }
            this.fireEndPropertyEvent = false;
            return this.createEndPropertyEvent(null, JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.NULL);
        }
        if (this.hasNext()) {
            JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken token = this.tokenizer.nextToken();
            switch (this.state.peek()) {
                case NONE: {
                    if (token.type != JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.LEFT_CURLY_BRACKET) {
                        throw new JsonStreamReaderFactory.JsonParseException("no JSON format must start with {");
                    }
                    return this.createStartObjectEvent();
                }
                case OBJECT: {
                    if (this.expectCommaOrEnd) {
                        if (token.type == JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.COMMA) {
                            if (!this.tokenizer.hasNext()) {
                                throw new JsonStreamReaderFactory.JsonParseException("no JSON format premature end");
                            }
                            token = this.tokenizer.nextToken();
                        } else if (token.type != JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.RIGHT_CURLY_BRACKET) {
                            throw new JsonStreamReaderFactory.JsonParseException("no JSON format expected , or ] got " + (Object)((Object)token.type));
                        }
                        this.expectCommaOrEnd = false;
                    }
                    switch (token.type) {
                        case STRING: {
                            if (!this.tokenizer.hasNext() || this.tokenizer.nextToken().type != JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.COLON) {
                                throw new JsonStreamReaderFactory.JsonParseException("no JSON format : expected afer " + token.value);
                            }
                            this.expectCommaOrEnd = true;
                            return this.createStartPropertyEvent(token.value);
                        }
                        case RIGHT_CURLY_BRACKET: {
                            return this.createEndObjectEvent();
                        }
                    }
                    throw new JsonStreamReaderFactory.JsonParseException("no JSON format");
                }
                case PROPERTY: {
                    switch (token.type) {
                        case STRING: 
                        case NUMBER: 
                        case TRUE: 
                        case FALSE: {
                            return this.createEndPropertyEvent(token.value, token.type);
                        }
                        case NULL: {
                            return this.createEndPropertyEvent(null, token.type);
                        }
                        case LEFT_CURLY_BRACKET: {
                            return this.createStartObjectEvent();
                        }
                        case LEFT_BRACKET: {
                            return this.createStartArrayEvent();
                        }
                    }
                    throw new JsonStreamReaderFactory.JsonParseException("no JSON format");
                }
                case ARRAY: {
                    if (this.expectCommaOrEnd) {
                        if (token.type == JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.COMMA) {
                            if (!this.tokenizer.hasNext()) {
                                throw new JsonStreamReaderFactory.JsonParseException("no JSON format premature end");
                            }
                            token = this.tokenizer.nextToken();
                        } else if (token.type != JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.RIGHT_BRACKET) {
                            throw new JsonStreamReaderFactory.JsonParseException("no JSON format expected , or ]");
                        }
                        this.expectCommaOrEnd = false;
                    }
                    switch (token.type) {
                        case STRING: 
                        case NUMBER: 
                        case TRUE: 
                        case FALSE: {
                            this.expectCommaOrEnd = true;
                            return this.createValueEvent(token.value);
                        }
                        case NULL: {
                            this.expectCommaOrEnd = true;
                            return this.createValueEvent(null);
                        }
                        case LEFT_CURLY_BRACKET: {
                            this.expectCommaOrEnd = true;
                            return this.createStartObjectEvent();
                        }
                        case LEFT_BRACKET: {
                            this.expectCommaOrEnd = true;
                            return this.createStartArrayEvent();
                        }
                        case RIGHT_BRACKET: {
                            return this.createEndArrayEvent();
                        }
                    }
                }
            }
        }
        this.previousEvent = null;
        throw new RuntimeException("no event");
    }

    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent createStartPropertyEvent(final String name) {
        this.state.push(ReaderState.PROPERTY);
        JsonStreamReaderImpl.dump("jsonp start property: " + name);
        this.previousEvent = new JsonStartPropertyEventImpl(){

            @Override
            public String getName() {
                return name;
            }
        };
        return this.previousEvent;
    }

    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent createEndPropertyEvent(final String value, final JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType valueTokenType) {
        this.state.pop();
        JsonStreamReaderImpl.dump("jsonp end property: " + value);
        this.previousEvent = new JsonEndPropertyEventImpl(){

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType getValueTokenType() {
                return valueTokenType;
            }
        };
        return this.previousEvent;
    }

    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent createStartObjectEvent() {
        this.state.push(ReaderState.OBJECT);
        JsonStreamReaderImpl.dump("jsonp start object");
        this.expectCommaOrEndStack.push(this.expectCommaOrEnd);
        this.expectCommaOrEnd = false;
        this.previousEvent = new JsonEventImpl(){

            @Override
            public boolean isStartObject() {
                return true;
            }
        };
        return this.previousEvent;
    }

    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent createEndObjectEvent() {
        this.state.pop();
        JsonStreamReaderImpl.dump("jsonp end object");
        this.expectCommaOrEnd = this.expectCommaOrEndStack.pop();
        if (this.state.peek() == ReaderState.PROPERTY) {
            this.fireEndPropertyEvent = true;
        }
        this.previousEvent = new JsonEventImpl(){

            @Override
            public boolean isEndObject() {
                return true;
            }
        };
        return this.previousEvent;
    }

    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent createStartArrayEvent() {
        this.state.push(ReaderState.ARRAY);
        JsonStreamReaderImpl.dump("jsonp start array");
        this.expectCommaOrEndStack.push(this.expectCommaOrEnd);
        this.expectCommaOrEnd = false;
        this.previousEvent = new JsonEventImpl(){

            @Override
            public boolean isStartArray() {
                return true;
            }
        };
        return this.previousEvent;
    }

    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent createEndArrayEvent() {
        this.state.pop();
        JsonStreamReaderImpl.dump("jsonp end array");
        this.expectCommaOrEnd = this.expectCommaOrEndStack.pop();
        if (this.state.peek() == ReaderState.PROPERTY) {
            this.fireEndPropertyEvent = true;
        }
        this.previousEvent = new JsonEventImpl(){

            @Override
            public boolean isEndArray() {
                return true;
            }
        };
        return this.previousEvent;
    }

    private JsonStreamReaderFactory.JsonStreamReader.JsonEvent createValueEvent(final String value) {
        JsonStreamReaderImpl.dump("jsonp value: " + value);
        this.previousEvent = new JsonValueEventImpl(){

            @Override
            public String getValue() {
                return value;
            }
        };
        return this.previousEvent;
    }

    @Override
    public JsonStreamReaderFactory.JsonStreamReader.JsonEvent previousEvent() {
        return this.previousEvent;
    }

    @Override
    public void skipNestedEvents() {
        if (!(this.previousEvent.isStartProperty() || this.previousEvent.isStartObject() || this.previousEvent.isStartArray())) {
            return;
        }
        int stackSize = this.state.size();
        while (this.hasNext() && this.state.size() >= stackSize) {
            this.nextEvent();
        }
    }

    @Override
    public void close() {
        this.tokenizer.close();
    }
}

