/*
 * Copyright 2013 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.overlord.dtgov.ui.server.filters;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.overlord.dtgov.i18n.AbstractMessages;
import org.overlord.dtgov.ui.server.services.sramp.SrampApiClientAccessor;
import org.overlord.dtgov.ui.server.services.tasks.TaskClientAccessor;

/**
 * A filter used to configure the i18n system to obey any inbound locale information.  In
 * other words, this filter is used to pull the locale info from an inbound http request and
 * place it in the {@link AbstractMessages}'s locale thread local variable.
 * @author eric.wittmann@redhat.com
 */
public class LocaleFilter implements Filter {

    /**
     * Constructor.
     */
    public LocaleFilter() {
    }

    /**
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /**
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        Locale locale = request.getLocale();
        AbstractMessages.setLocale(locale);
        SrampApiClientAccessor.setLocale(locale);
        TaskClientAccessor.setLocale(locale);
        chain.doFilter(request, response);
        AbstractMessages.clearLocale();
        SrampApiClientAccessor.clearLocale();
        TaskClientAccessor.clearLocale();
    }

    /**
     * @see javax.servlet.Filter#destroy()
     */
    @Override
    public void destroy() {
    }

}
