package com.redhat.installer.action;

import java.util.Properties;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;

/**
 * @author Jyoti Tripathi
 */
public class PortDefaultReset implements PanelAction  {

    /**
     * @param handler Note, as per spec., if there isn't a GUI, handler is null
     */
    public void executeAction(final AutomatedInstallData idata, AbstractUIHandler handler)  {
        String product = idata.getVariable("product.name");
        
        /**
         * We do not want to run this condition if we are installing anything
         * other than EAP, but custom actions don't support the 'condition' tag
         * in the install.xml spec file. Extension for izpack? One day!
         */
        if ( product != null && !product.contains("eap")) {
            Debug.log("Skipping port default resets since this is not an EAP installation.");
            return;
        }
        


        String useCustomPorts = idata.getVariable("portDecision");
        if (useCustomPorts.equals("off")) {
            Properties variables = idata.getVariables();
            String[] varNames = variables.stringPropertyNames().toArray(new String[0]);
            for (String variable : varNames) {
                if ( (variable.startsWith("domain") || variable.startsWith("standalone")) 
                        && !variable.endsWith("-1") && !variable.endsWith("-2") 
                        && !variable.endsWith(".orig")) {
                    String oldvalue = variables.getProperty(variable);
                    String value = variables.getProperty(variable+".orig");
                    if (value != null) {
                        idata.setVariable(variable, value);
                    }
                }
            }
        }
    }

    /**
     * There shouldn't be any need for configuration, since this is a dedicated class
     * @param configuration null if no configuration block for the action
     */
    public void initialize(PanelActionConfiguration configuration) {
    }
}
