package com.redhat.installer.password;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.postinstall.ArgumentParser;
import com.redhat.installer.postinstall.PostInstallUserHelper;

public class AddProperties {
        private static AutomatedInstallData idata; // all of the install data variables and the like
        final static String pathToMgmtFile = "/configuration/mgmt-users.properties";
        final static String[] profiles = new String[] {"standalone", "domain"};
    private static boolean setRole = false;

        public static void run(AbstractUIProcessHandler handler, String[] args) throws Exception {
        idata = AutomatedInstallData.getInstance();

        // Immediately exit if we are not adding a new user to installation.
        if (idata.getVariable("add.new.user").contains("false")) {
            return;
        }

        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);


        String username = parser.getProperty("user", "post-install");
        String password = parser.getProperty("password", "");
        String realm = parser.getProperty("realm", "");
        String basepath = parser.getProperty("base-dir", "");
        String pathToFile = parser.getProperty("target-file", pathToMgmtFile);
        String outputString = parser.getProperty("job-message",
                "postinstall.processpanel.user.added");


        /**
         * In case we are writing a user role rather than a user/pwd.
         */
        if (parser.hasProperty("role")) {
            setRole = true;
            password = parser.getProperty("role");
        } else {
            setRole = false;
        }


        try {
            addUser(username, password, realm, basepath, true, pathToFile);
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return;
        }
        handler.logOutput(
idata.langpack.getString(outputString),
                false);
        }

        /**
     * Use this method to add a user/pwd pair to the specified files directly.
     * 
     * @param username
     * @param password
     * @param realm
     * @param path
     * @throws Exception
     */
    public static void addUser(String username, String password, String realm,
            String path, boolean append, String pathToFile) throws Exception {
		idata = AutomatedInstallData.getInstance();				
		
		String installerMode = idata.getVariable("installerMode");

        /**
         * If this is NOT an auto-installation AND this is NOT the post-install
         * user, we want to hash. Otherwise, we plaintext the password.
         */
        String hash = (!installerMode.equals("AUTO") &&
 !username.equals(PostInstallUserHelper.username) && !setRole)
 ? new UsernamePasswordHashUtil()
                .generateHashedHexURP(username, realm, password.toCharArray())
                : password;

		try {
			// Create file
            StringBuilder out = new StringBuilder();
			for (String profile : profiles) {
                out.setLength(0);
                File oldfile = new File(path + "/" + profile + pathToFile);
				BufferedReader in = new BufferedReader(new FileReader(oldfile));
				String line;
				boolean userfound = false;

				while ((line = in.readLine()) != null) {
					if (line.contains(username) && !line.startsWith("#")) {
						out.append(username + "=" + hash);
						userfound = true;
					} else {
						out.append(line);
					}
					out.append(System.getProperty("line.separator"));
				}

				if (!userfound) {
					out.append(username + "=" + hash);
				}

				// Close the stream
				in.close();
				if (oldfile.delete()) {
					// Overwrite the old file with the new version.
                    FileWriter writer = new FileWriter(path + "/" + profile
                            + pathToFile, false);
					writer.write(out.toString());
					writer.close();
				} else {
                    System.err.println("Error replacing " + pathToFile
                            + " file.");
				}

			}
		} catch (Exception e) {// Catch exception if any
            System.err.println("Error creating " + pathToFile + " file: "
                    + e.getMessage());
		}
	}

    /**
     * Same as above, but uses default mgmt-properties as target file.
     * 
     * @param username
     * @param password
     * @param realm
     * @param path
     * @param append
     */
    public static void addUser(String username, String password, String realm,
            String path, boolean append) throws Exception {
        addUser(username, password, realm, path, append, pathToMgmtFile);
    }
        /**
         * Removes a user/pwd line from the mgmt-users.properties file.
         * @param username The username to look for and remove.
         * @param realm
         * @param path
         */
    public static void removeUser(String username, String path) {
            String line;
            try {
            StringBuilder file = new StringBuilder();
                for (String profile: profiles) {
                    FileReader reader = new FileReader(path + "/" + profile + pathToMgmtFile);
                    BufferedReader in = new BufferedReader(reader);
                file.setLength(0);

                    // Loop through the entire file and copy it.
                    while((line = in.readLine()) != null) {
                        // If we find the line containing the username,
                        // don't copy it.
                        if (!line.contains(username)) {
                            file.append(line);
                            file.append(System.getProperty("line.separator"));
                        }
                    }
                    in.close();
                    reader.close();

                    // Overwrite the old file with the new copy.
                    FileWriter writer = new FileWriter(path + "/" + profile + pathToMgmtFile,false);
                    writer.write(file.toString());
                    writer.close();
                }

            } catch (Exception e) {
                //e.printStackTrace();
                //System.err.println("Error replacing mgmt-users.properties file: " + e.getMessage());
            }
        }
}
