package com.redhat.installer.postinstall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * Generalized class to set properties with a given key, in a given properties file to new values. 
 *
 * @author thauser
 *
 */
public class PropertiesSetter {

	private static AbstractUIProcessHandler mHandler;
	
	public static boolean run(AbstractUIProcessHandler handler, String[]args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
		mHandler = handler;
		boolean newFile = false;
		File propsFile = new File(args[0]);
		if (!propsFile.exists()){
			//ProcessPanelHelper.printToPanel(mHandler, "Properties file doesn't exist: " + propsFile.getPath(),false);
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.notexist") + " "  + propsFile.getPath(),false);
			//ProcessPanelHelper.printToPanel(mHandler,"Creating new file at " + propsFile.getPath(), false);
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.newfile") + " " +  propsFile.getPath(), false);
			try {
				propsFile.createNewFile();
			} catch (IOException e) {
				// we print this here, this points to an error in the izpack descriptors.
				e.printStackTrace();
				return false;
			}
			newFile = true;
		}
		//String[] properties = new String [args.length-1];
/*		for (int i = 0; i < properties.length; i++){
			properties[i] = args[i+1];
		}*/
		ArrayList<String> properties = new ArrayList<String>(5);
		for (int i = 1; i < args.length; i++){
			properties.add(args[i]);
		}
		String line;
		BufferedReader br= null;
		try {
			br = new BufferedReader(new FileReader(propsFile));
		} catch (FileNotFoundException e) {
			// this will never be reached. propsFile is guaranteed to exist provided correct usage in ProcessPanel.Spec.xml
			e.printStackTrace();
			
		}
		StringBuilder sb = new StringBuilder();
		
		// not a new file
		if (!newFile) {
			try {
				while ((line = br.readLine()) != null) {
					boolean foundMatch = false;
					for (String property : properties) {
						// get the key
						String origKey = line.split("=")[0].trim();
						String matchKey = property.substring(0, property.indexOf('='));
						// System.out.println("Key = " + key);
						// get the value for the key
						String newValue = property.substring(property.indexOf('=') + 1);

						// System.out.println("Value = " + value);
						// check for the replacement
						if (origKey.equals(matchKey)) {
							sb.append(origKey + "=" + newValue);
							// System.out.println("Appended "+ key + "=" + value +
							// " to file " + propsFile.getPath());
							foundMatch = true;
							properties.remove(property); //remove the matched property from the list
							break; // break from searching more props if we found
									// one for this line
						}
					}
					if (!foundMatch) {
						sb.append(line);
					}
					sb.append(System.getProperty("line.separator"));
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			// if there are any other properties left, write them out verbatim.
			for (String property : properties){
				sb.append(property);
                sb.append(System.getProperty("line.separator"));
			}
		} else {
			// the file is new. simply add the properties array to the stringbuilder
			for (String property : properties){
				sb.append(property);
                sb.append(System.getProperty("line.separator"));
			}
		}
		
		// file should be correct now. write her out!
		try {
			br.close();
		} catch (IOException e) {
			// probably not catastrophic if this fails
			e.printStackTrace();
		}
		
		// TODO this is essentially copied from AddProperties, perhaps we can factor it out to a util class
		if (propsFile.delete()){
			FileWriter writer;
			try {
				writer = new FileWriter(propsFile, false);
				writer.write(sb.toString());
                //ProcessPanelHelper.printToPanel(mHandler, "Successfully wrote properties to: "+propsFile.getPath(), false);
				ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.success") + " " + propsFile.getPath(), false);
				writer.close();
				return true;
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
                return false;
			}
		} else {
			//ProcessPanelHelper.printToPanel(mHandler, "Failed to write properties to: " + propsFile.getPath(), true);
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("PropertiesSetter.failure") + " "  + propsFile.getPath(), true);
			return false;
		}
	}
}
