package org.jboss.ip.dbtool;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

/**
 * @author Alex Creasy <acreasy@redhat.com>
 */
public final class Database {

    private static final Set<String> ids = new HashSet<String>();

    private final String id;
    private final String descriptiveName;
    private final String connectionUrlPattern;
    private final int defaultPort;
    private final String sqlDialect;
    private final String hibernateSqlDialect;

    private final String driverName;
    private final String driverJarFileName;
    private final String driverClass;
    private final String driverXaDatasourceClass;
    private final String driverModuleName;
    private final String driverInstallLocation;
    private final String driverExceptionSorter;
    private final String driverValidConnectionChecker;
    private final String driverStaleConnectionChecker;

    public static Database newInstance(final String id, final Properties props) {
        return new Database.Builder()
                .setId(id)
                .setDescriptiveName(props.getProperty("database.descriptive.name"))
                .setDefaultPort(Integer.parseInt(props.getProperty("database.default.port")))
                .setConnectionUrlPattern(props.getProperty("database.connection.url.pattern"))
                .setSqlDialect(props.getProperty("database.sql.dialect"))
                .setHibernateSqlDialect(props.getProperty("database.hibernate.sql.dialect"))

                .setDriverName(props.getProperty("database.driver.name"))
                .setDriverJarFileName(props.getProperty("database.driver.jar.filename"))
                .setDriverClass(props.getProperty("database.driver.class"))
                .setDriverXaDatasourceClass(props.getProperty("database.driver.xa.datasource.class"))
                .setDriverModuleName(props.getProperty("database.driver.module.name"))
                .setDriverInstallLocation(props.getProperty("database.driver.install.location"))
                .setDriverExceptionSorter(props.getProperty("database.driver.exception.sorter"))
                .setDriverValidConnectionChecker(props.getProperty("database.driver.valid.connection.checker"))
                .setDriverStaleConnectionChecker(props.getProperty("database.driver.stale.connection.checker"))

                .build();
    }

    public Database(String id, String descriptiveName, String connectionUrlPattern, int defaultPort, String sqlDialect,
                    String hibernateSqlDialect, String driverName, String driverJarFileName,
                    String driverClass, String driverXaDatasourceClass, String driverModuleName,
                    String driverInstallLocation, String driverExceptionSorter, String driverValidConnectionChecker,
                    String driverStaleConnectionChecker) {

        this.id = id;
        this.descriptiveName = descriptiveName;
        this.connectionUrlPattern = connectionUrlPattern;
        this.defaultPort = defaultPort;
        this.sqlDialect = sqlDialect;
        this.hibernateSqlDialect = hibernateSqlDialect;
        this.driverName = driverName;
        this.driverJarFileName = driverJarFileName;
        this.driverClass = driverClass;
        this.driverXaDatasourceClass = driverXaDatasourceClass;
        this.driverModuleName = driverModuleName;
        this.driverInstallLocation = driverInstallLocation;
        this.driverExceptionSorter = driverExceptionSorter;
        this.driverValidConnectionChecker = driverValidConnectionChecker;
        this.driverStaleConnectionChecker = driverStaleConnectionChecker;
    }

    public String getId() {
        return id;
    }

    public String getDescriptiveName() {
        return descriptiveName;
    }

    public String getConnectionUrlPattern() {
        return connectionUrlPattern;
    }

    public String getHibernateSqlDialect() {
        return hibernateSqlDialect;
    }

    public String getSqlDialect() {
        return sqlDialect;
    }

    public int getDefaultPort() {
        return defaultPort;
    }

    public String getDriverName() {
        return driverName;
    }

    public String getDriverJarFileName() {
        return driverJarFileName;
    }

    public String getDriverClass() {
        return driverClass;
    }

    public String getDriverXaDatasourceClass() {
        return driverXaDatasourceClass;
    }

    public String getDriverModuleName() {
        return driverModuleName;
    }

    public String getDriverInstallLocation() {
        return driverInstallLocation;
    }

    public String getDriverExceptionSorter() {
        return driverExceptionSorter;
    }

    public String getDriverValidConnectionChecker() {
        return driverValidConnectionChecker;
    }

    public String getDriverStaleConnectionChecker() {
        return driverStaleConnectionChecker;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Database{");
        sb.append("id='").append(id).append('\'');
        sb.append(", descriptiveName='").append(descriptiveName).append('\'');
        sb.append(", connectionUrlPattern='").append(connectionUrlPattern).append('\'');
        sb.append(", defaultPort=").append(defaultPort);
        sb.append(", sqlDialect='").append(sqlDialect).append('\'');
        sb.append(", hibernateSqlDialect='").append(hibernateSqlDialect).append('\'');
        sb.append(", driverName='").append(driverName).append('\'');
        sb.append(", driverJarFileName='").append(driverJarFileName).append('\'');
        sb.append(", driverClass='").append(driverClass).append('\'');
        sb.append(", driverXaDatasourceClass='").append(driverXaDatasourceClass).append('\'');
        sb.append(", driverModuleName='").append(driverModuleName).append('\'');
        sb.append(", driverInstallLocation='").append(driverInstallLocation).append('\'');
        sb.append(", driverExceptionSorter='").append(driverExceptionSorter).append('\'');
        sb.append(", driverValidConnectionChecker='").append(driverValidConnectionChecker).append('\'');
        sb.append(", driverStaleConnectionChecker='").append(driverStaleConnectionChecker).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private String id;
        private String descriptiveName;
        private String connectionUrlPattern;
        private int defaultPort;
        private String sqlDialect;
        private String hibernateSqlDialect;
        private String driverName;
        private String driverJarFileName;
        private String driverClass;
        private String driverXaDatasourceClass;
        private String driverModuleName;
        private String driverInstallLocation;
        private String driverExceptionSorter;
        private String driverValidConnectionChecker;
        private String driverStaleConnectionChecker;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDescriptiveName(String descriptiveName) {
            this.descriptiveName = descriptiveName;
            return this;
        }

        public Builder setDefaultPort(int defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public Builder setConnectionUrlPattern(String connectionUrlPattern) {
            this.connectionUrlPattern = connectionUrlPattern;
            return this;
        }

        public Builder setSqlDialect(String sqlDialect) {
            this.sqlDialect = sqlDialect;
            return this;
        }

        public Builder setHibernateSqlDialect(String hibernateSqlDialect) {
            this.hibernateSqlDialect = hibernateSqlDialect;
            return this;
        }

        public Builder setDriverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder setDriverJarFileName(String driverJarFileName) {
            this.driverJarFileName = driverJarFileName;
            return this;
        }

        public Builder setDriverClass(String driverClass) {
            this.driverClass = driverClass;
            return this;
        }

        public Builder setDriverXaDatasourceClass(String driverXaDatasourceClass) {
            this.driverXaDatasourceClass = driverXaDatasourceClass;
            return this;
        }

        public Builder setDriverModuleName(String driverModuleName) {
            this.driverModuleName = driverModuleName;
            return this;
        }

        public Builder setDriverInstallLocation(String driverInstallLocation) {
            this.driverInstallLocation = driverInstallLocation;
            return this;
        }

        public Builder setDriverExceptionSorter(String driverExceptionSorter) {
            this.driverExceptionSorter = driverExceptionSorter;
            return this;
        }

        public Builder setDriverValidConnectionChecker(String driverValidConnectionChecker) {
            this.driverValidConnectionChecker = driverValidConnectionChecker;
            return this;
        }

        public Builder setDriverStaleConnectionChecker(String driverStaleConnectionChecker) {
            this.driverStaleConnectionChecker = driverStaleConnectionChecker;
            return this;
        }

        public Database build() {

            final Database db = new Database(id, descriptiveName, connectionUrlPattern, defaultPort, sqlDialect,
                    hibernateSqlDialect, driverName, driverJarFileName, driverClass, driverXaDatasourceClass,
                    driverModuleName, driverInstallLocation, driverExceptionSorter, driverValidConnectionChecker,
                    driverStaleConnectionChecker);

            if (db.id.isEmpty())
                throw new IllegalArgumentException("id cannot be empty");

            if (ids.contains(db.id))
                throw new IllegalStateException("Non-unique id: " + db.id);

            if (db.descriptiveName.isEmpty())
                throw new IllegalArgumentException("descriptiveName cannot be empty");

            ids.add(id);
            return db;
        }
    }
}
