// This code is taken from WSO2 Carbon and is licensed by WSO2, Inc.
// under the Apache License version 2.0 http://www.apache.org/licenses/LICENSE-2.0.html
package org.wso2.carbon.bpel.ui.bpel2svg;

import java.util.*;

import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface.ActivityState;

public class LayoutManager {
    // Variables
    // Properties
    private int svgWidth = 1400;

    public int getSvgWidth() {
        return svgWidth;
    }

    public void setSvgWidth(int svgWidth) {
        this.svgWidth = svgWidth;
    }

    private int svgHeight = 1000;

    public int getSvgHeight() {
        return svgHeight;
    }

    public void setSvgHeight(int svgHeight) {
        this.svgHeight = svgHeight;
    }

    private int xSpacing = 20;

    public int getXSpacing() {
        return xSpacing;
    }

    public void setXSpacing(int xSpacing) {
        this.xSpacing = xSpacing;
    }

    private int ySpacing = 50;

    public int getYSpacing() {
        return ySpacing;
    }

    public void setYSpacing(int ySpacing) {
        this.ySpacing = ySpacing;
    }

    private boolean includeAssigns = true;

    public boolean isIncludeAssigns() {
        return includeAssigns;
    }

    public void setIncludeAssigns(boolean includeAssigns) {
        this.includeAssigns = includeAssigns;
    }

    private boolean showSequenceBoxes = true;

    public boolean isShowSequenceBoxes() {
        return showSequenceBoxes;
    }

    public void setShowSequenceBoxes(boolean showSequenceBoxes) {
        this.showSequenceBoxes = showSequenceBoxes;
    }

    private boolean verticalLayout = false;            //this should be implement in some where

    public boolean isVerticalLayout() {
        return verticalLayout;
    }

    public void setVerticalLayout(boolean verticalLayout) {
        this.verticalLayout = verticalLayout;
    }

    private boolean addCompositeActivityOpacity = false;

    public boolean isAddCompositeActivityOpacity() {
        return addCompositeActivityOpacity;
    }

    public void setAddCompositeActivityOpacity(boolean addCompositeActivityOpacity) {
        this.addCompositeActivityOpacity = addCompositeActivityOpacity;
    }

    private boolean addIconOpacity = false;

    public boolean isAddIconOpacity() {
        return addIconOpacity;
    }

    public void setAddIconOpacity(boolean addIconOpacity) {
        this.addIconOpacity = addIconOpacity;
    }

    private boolean addSimpleActivityOpacity = true;

    public boolean isAddSimpleActivityOpacity() {
        return addSimpleActivityOpacity;
    }

    public void setAddSimpleActivityOpacity(boolean addSimpleActivityOpacity) {
        this.addSimpleActivityOpacity = addSimpleActivityOpacity;
    }

    private double iconOpacity = 0.4;

    public double getCompositeActivityOpacity() {
        return compositeActivityOpacity;
    }

    public void setCompositeActivityOpacity(double compositeActivityOpacity) {
        this.compositeActivityOpacity = compositeActivityOpacity;
    }

    private double opacity = 0.50;

    public double getIconOpacity(ActivityState state) {
    	double ret=iconOpacity;
    	
    	if (state != ActivityState.Ready) {
    		ret = 1.0;
     	}
    	
        return ret;
    }

    public void setIconOpacity(double iconOpacity) {
        this.iconOpacity = iconOpacity;
    }

    private double simpleActivityOpacity = 0.351;

    public double getOpacity() {
        return opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    private double compositeActivityOpacity = 0.10;

    public double getSimpleActivityOpacity(ActivityState state) {
    	double ret=simpleActivityOpacity;
    	
    	if (state == ActivityState.Active) {
    		ret = 1.0;
    	} else if (state == ActivityState.Completed ||
    			state == ActivityState.Failed) {
    		ret += 0.3;
    	}
    	
        return ret;
    }

    public void setSimpleActivityOpacity(double simpleActivityOpacity) {
        this.simpleActivityOpacity = simpleActivityOpacity;
    }

    private int startIconDim = 32;

    public int getStartIconDim() {
        return startIconDim;
    }

    public void setStartIconDim(int startIconDim) {
        this.startIconDim = startIconDim;
    }

    private int endIconDim = 22;

    public int getEndIconDim() {
        return endIconDim;
    }

    public void setEndIconDim(int endIconDim) {
        this.endIconDim = endIconDim;
    }

    // Methods
    public void layoutSVG(ActivityInterface rootActivity) {
        rootActivity.getDimensions();
        //rootActivity.layout(0, 0);
        layoutLinks(rootActivity);
       // rootActivity.getDimensions();
        rootActivity.layout(0, 0);

    }

    private Map<ActivityInterface, ArrayList<ActivityInterface>> getLinkAdjacencyList(Map<String, Link> links) {
        Map<org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface, ArrayList<ActivityInterface>> linkAdjacencyList =
                new HashMap<ActivityInterface, ArrayList<ActivityInterface>>();
        if (links != null && !links.isEmpty()) {
            Set linksSet = links.entrySet();
            Iterator linksIterator = linksSet.iterator();
            while(linksIterator.hasNext()){
                Map.Entry<String, Link> link = (Map.Entry<String, Link>)linksIterator.next();
                ActivityInterface startActivity = link.getValue().getSource();
                ActivityInterface endActivity = link.getValue().getTarget();
                if (linkAdjacencyList.containsKey(startActivity)) {
                    linkAdjacencyList.get(startActivity).add(endActivity);
                }
                else {
                    ArrayList<ActivityInterface> tmpArrayList = new ArrayList<ActivityInterface>();
                    tmpArrayList.add(endActivity);
                    linkAdjacencyList.put(startActivity, tmpArrayList);
                }
            }
        }
        return linkAdjacencyList;
    }

    private Map<ActivityInterface, ArrayList<ActivityInterface>> linkAdjacencyList;
    private Set<ActivityInterface> rootLinks;
    private int correctionCumulation = 0;
    private int hieghestCorrectionCumulation = 0;

    private void setCorrectionY(ActivityInterface source, ArrayList<ActivityInterface> children) {
        if (children != null && !children.isEmpty()) {
            for (ActivityInterface target : children) {
                int whereTargetShouldBe = (source.getStartIconYTop() + source.getStartIconHeight() + 40);
                int whereTargetIs = target.getStartIconYTop();
                int correction = whereTargetShouldBe - whereTargetIs;
                if (whereTargetIs < whereTargetShouldBe) {  //the correction is included in YTop
                    target.setCorrectionY(correction);
                    int relativeCorrection = whereTargetShouldBe - source.getStartIconYTop();
                    correctionCumulation += relativeCorrection;
                    setCorrectionY(target, linkAdjacencyList.get(target));
                    correctionCumulation -= relativeCorrection;
                }
            }
        }
        else {
            if (hieghestCorrectionCumulation < correctionCumulation) {
                hieghestCorrectionCumulation = correctionCumulation;
            }
        }
    }

    private void layoutLinks(ActivityInterface rootActivity) {
        Map<String, Link> links = rootActivity.getLinks();
        if (links != null && !links.isEmpty()) {
            linkAdjacencyList = getLinkAdjacencyList(links);
            rootLinks = rootActivity.getLinkRoots();            // this shud b static

            for (ActivityInterface root : rootLinks) {
                correctionCumulation = 0;
                setCorrectionY(root, linkAdjacencyList.get(root));
            }

            ActivityInterface tempParent = rootLinks.iterator().next().getParent();         //chk for empty set
            while (tempParent != null) {
                int tempHeight = tempParent.getDimensions().getHeight();
                tempParent.getDimensions().setHeight(tempHeight + hieghestCorrectionCumulation);           //this should b corrected
                tempParent = tempParent.getParent();
            }

            rootLinks.clear();
        }
    }
}
