/*
 * Copyright 2014 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.artificer.server.core.api;

import org.artificer.repository.query.PagedResult;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;

/**
 * @author Brett Meyer.
 */
public interface AuditService extends AbstractService {

    public AuditEntry create(String artifactUuid, AuditEntry auditEntry) throws Exception;

    public AuditEntry get(String artifactUuid, String auditEntryUuid) throws Exception;

    public PagedResult<AuditEntry> queryByArtifact(String artifactUuid) throws Exception;

    public PagedResult<AuditEntry> queryByArtifact(String artifactUuid, Integer startPage, Integer startIndex, Integer count)
            throws Exception;

    public PagedResult<AuditEntry> queryByUser(String username) throws Exception;

    public PagedResult<AuditEntry> queryByUser(String username, Integer startPage, Integer startIndex, Integer count)
            throws Exception;
}
