/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XsltUriResolver
implements URIResolver {
    private static final transient Log LOG = LogFactory.getLog(XsltUriResolver.class);
    private final ClassResolver resolver;
    private final String location;

    public XsltUriResolver(ClassResolver resolver, String location) {
        this.resolver = resolver;
        this.location = location;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (ObjectHelper.isEmpty(href)) {
            throw new TransformerException("include href is empty");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Resolving URI with href: " + href + " and base: " + base));
        }
        if (href.startsWith("classpath:")) {
            String name;
            InputStream is;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resolving URI from classpath: " + href));
            }
            if ((is = this.resolver.loadResourceAsStream(name = ObjectHelper.after(href, ":"))) == null) {
                throw new TransformerException("Cannot find " + name + " in classpath");
            }
            return new StreamSource(is);
        }
        if (href.startsWith("file:")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resolving URI from file: " + href));
            }
            String name = ObjectHelper.after(href, ":");
            File file = new File(name);
            return new StreamSource(file);
        }
        String path = FileUtil.onlyPath(this.location);
        if (ObjectHelper.isEmpty(path)) {
            path = "classpath:" + href;
            return this.resolve(path, base);
        }
        path = "classpath:" + path + File.separator + href;
        return this.resolve(path, base);
    }
}

