/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.util.ObjectHelper;

public class StringSource
extends StreamSource
implements Externalizable {
    private String text;
    private String encoding = "UTF-8";

    public StringSource() {
    }

    public StringSource(String text) {
        ObjectHelper.notNull(text, "text");
        this.text = text;
    }

    public StringSource(String text, String systemId) {
        this(text);
        ObjectHelper.notNull(systemId, "systemId");
        this.setSystemId(systemId);
    }

    public StringSource(String text, String systemId, String encoding) {
        this(text, systemId);
        ObjectHelper.notNull(encoding, "encoding");
        this.encoding = encoding;
    }

    public InputStream getInputStream() {
        try {
            return new ByteArrayInputStream(this.text.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Reader getReader() {
        return new StringReader(this.text);
    }

    public String toString() {
        return "StringSource[" + this.text + "]";
    }

    public String getText() {
        return this.text;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int b = (this.text != null ? 1 : 0) + (this.encoding != null ? 2 : 0) + (this.getPublicId() != null ? 4 : 0) + (this.getSystemId() != null ? 8 : 0);
        out.writeByte(b);
        if ((b & 1) != 0) {
            out.writeUTF(this.text);
        }
        if ((b & 2) != 0) {
            out.writeUTF(this.encoding);
        }
        if ((b & 4) != 0) {
            out.writeUTF(this.getPublicId());
        }
        if ((b & 8) != 0) {
            out.writeUTF(this.getSystemId());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte b = in.readByte();
        if ((b & 1) != 0) {
            this.text = in.readUTF();
        }
        if ((b & 2) != 0) {
            this.encoding = in.readUTF();
        }
        if ((b & 4) != 0) {
            this.setPublicId(in.readUTF());
        }
        if ((b & 8) != 0) {
            this.setSystemId(in.readUTF());
        }
    }
}

