/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package javax.jbi.messaging;

/**
 * Supports operations used to process an In Optional Out MEP to completion.
 *
 * @author JSR208 Expert Group
 */
public interface InOptionalOut extends MessageExchange {

    /**
     * Retrieves the <i>in</i> normalized message from this exchange.
     *
     * @return in message
     */
    NormalizedMessage getInMessage();

    /**
     * Retrieves the <i>out</i> normalized message from this exchange.
     *
     * @return out message
     */
    NormalizedMessage getOutMessage();
    /**
     * Sets the <i>in</i> normalized message for this exchange.
     *
     * @param msg in message
     * @throws MessagingException unable to set in message
     */
    void setInMessage(NormalizedMessage msg) throws MessagingException;

    /**
     * Sets the <i>out</i> normalized message for this exchange.
     *
     * @param msg out message
     * @throws MessagingException unable to set out message
     */
    void setOutMessage(NormalizedMessage msg) throws MessagingException;

}
