/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocFactory;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.jco.JCoIDocServer;
import com.sap.conn.idoc.jco.rt.DefaultJCoIDocServer;
import com.sap.conn.idoc.jco.rt.DefaultJCoIDocServerFactory;
import com.sap.conn.idoc.jco.rt.JCoIDocDocumentList;
import com.sap.conn.idoc.jco.rt.JCoIDocRuntime;
import com.sap.conn.idoc.jco.rt.RawTable;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.idoc.rt.util.Utils;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.ServerFactory;
import com.sap.conn.jco.rt.StandaloneServerFactory;
import java.lang.reflect.Method;

public abstract class JCoIDoc {
    public static final String VERSION = "3.0.10 (2013-08-15)";
    private static final String MIN_REQUIRED_JCO_VERSION = "3.0.10";
    private static DefaultJCoIDocRuntime runtime = null;
    private static StandaloneServerFactory idocStandaloneServerFactory = null;

    public static IDocFactory getIDocFactory() {
        return runtime;
    }

    public static String getVersion() {
        return runtime.getVersion();
    }

    public static IDocRepository getIDocRepository(JCoDestination destination) throws JCoException {
        return runtime.createIDocRepository(destination);
    }

    public static JCoIDocServer getServer(String serverName) throws JCoException {
        if (idocStandaloneServerFactory == null) {
            DefaultJCoIDocServerFactory sf = new DefaultJCoIDocServerFactory();
            DefaultServerManager serverManager = DefaultServerManager.createCustomServerManager((ServerFactory)sf, null);
            idocStandaloneServerFactory = StandaloneServerFactory.createServerFactory((DefaultServerManager)serverManager);
        }
        DefaultJCoIDocServer idocServer = (DefaultJCoIDocServer)idocStandaloneServerFactory.getServerInstance(serverName);
        idocServer.setEnforceIDocHandlerFactory(true);
        return idocServer;
    }

    public static void send(IDocDocument idoc, char idocVersion, JCoDestination destination, String tid, String queueName) throws JCoException {
        JCoFunction function = runtime.createJCoFunction(idoc, idocVersion, 0, destination.getAttributes(), queueName);
        if (Trace.isOn(64)) {
            StringBuilder buf = new StringBuilder(128).append("[IDocAPI] Sending an IDoc of type ").append(idoc.getIDocType());
            String iDocTypeExtension = idoc.getIDocTypeExtension();
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                buf.append('|').append(iDocTypeExtension);
            }
            buf.append(" with ").append(idoc.getNumSegments()).append(" segments.");
            IDocSegmentMetaData iDocMetaData = idoc.getRootSegment().getSegmentMetaData();
            String systemRelease = iDocMetaData.getSystemRelease();
            if (systemRelease != null && systemRelease.length() > 0) {
                buf.append(" The release of the IDoc is " + systemRelease);
                String applicationRelease = iDocMetaData.getApplicationRelease();
                if (applicationRelease != null && applicationRelease.length() > 0) {
                    buf.append('|').append(applicationRelease);
                }
                buf.append('.');
            }
            Trace.fireTrace(64, buf.toString());
            buf.setLength(0);
            buf.append("[IDocAPI] IDoc is sent to destination ").append(destination.getDestinationName());
            buf.append(" as version '").append(idocVersion);
            buf.append("' with TID ").append(tid);
            if (queueName != null && queueName.length() > 0) {
                buf.append(" into queue ").append(queueName);
            }
            buf.append('.');
            Trace.fireTrace(64, buf.toString());
        }
        if (idocVersion == 'Q' || idocVersion == '8') {
            function.execute(destination, tid);
        } else {
            function.execute(destination, tid, queueName);
        }
    }

    public static void send(IDocDocumentList idocList, char idocVersion, JCoDestination destination, String tid, String queueName) throws JCoException {
        JCoFunction function = runtime.createJCoFunction(idocList, idocVersion, 0, destination.getAttributes(), queueName);
        if (Trace.isOn(64)) {
            StringBuilder buf = new StringBuilder(128).append("[IDocAPI] Sending an IDoc package of type ").append(idocList.getIDocType());
            String iDocTypeExtension = idocList.getIDocTypeExtension();
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                buf.append('|').append(iDocTypeExtension);
            }
            if (idocList.getNumDocuments() > 1) {
                buf.append(" with ").append(idocList.getNumDocuments()).append(" documents");
            } else if (idocList.getNumDocuments() == 1) {
                buf.append(" with a single document with ").append(idocList.get(0).getNumSegments()).append(" segments");
            }
            buf.append('.');
            String systemRelease = idocList.getSystemRelease();
            if (systemRelease != null && systemRelease.length() > 0) {
                buf.append(" The release of the IDocList is " + systemRelease);
                String applicationRelease = idocList.getApplicationRelease();
                if (applicationRelease != null && applicationRelease.length() > 0) {
                    buf.append('|').append(applicationRelease);
                }
                buf.append('.');
            }
            Trace.fireTrace(64, buf.toString());
            buf.setLength(0);
            buf.append("[IDocAPI] IDoc package is sent to destination ").append(destination.getDestinationName());
            buf.append(" as version '").append(idocVersion);
            buf.append("' with TID ").append(tid);
            if (queueName != null && queueName.length() > 0) {
                buf.append(" into queue ").append(queueName);
            }
            buf.append('.');
            Trace.fireTrace(64, buf.toString());
        }
        if (idocVersion == 'Q' || idocVersion == '8') {
            function.execute(destination, tid);
        } else {
            function.execute(destination, tid, queueName);
        }
    }

    public static void send(IDocDocument idoc, char idocVersion, JCoDestination destination, String tid) throws JCoException {
        JCoIDoc.send(idoc, idocVersion, destination, tid, null);
    }

    public static void send(IDocDocumentList idocList, char idocVersion, JCoDestination destination, String tid) throws JCoException {
        JCoIDoc.send(idocList, idocVersion, destination, tid, null);
    }

    static {
        try {
            Class<?> jcoClass = Class.forName("com.sap.conn.jco.JCo");
            Method getVersionM = jcoClass.getMethod("getVersion", null);
            String jcoVersion = (String)getVersionM.invoke(null, new Object[0]);
            int index = jcoVersion.indexOf(32);
            if (index >= 0) {
                jcoVersion = jcoVersion.substring(0, index);
            }
            if (Utils.versionsCompare(jcoVersion, MIN_REQUIRED_JCO_VERSION) < 0) {
                index = VERSION.indexOf(32);
                String ownVersion = index >= 0 ? VERSION.substring(0, index) : VERSION;
                throw new IDocRuntimeException("Initialization of the SAP Java IDoc Class Library " + ownVersion + " failed. " + "Found the SAP Java Connector version " + jcoVersion + " but " + "version " + MIN_REQUIRED_JCO_VERSION + " or a higher patch level is required.");
            }
            if (Utils.versionsCompare(jcoVersion, "6") >= 0) {
                index = VERSION.indexOf(32);
                String ownVersion = index >= 0 ? VERSION.substring(0, index) : VERSION;
                throw new IDocRuntimeException("Initialization of the SAP Java IDoc Class Library " + ownVersion + " failed. " + "Found the SAP Java Connector integrated version " + jcoVersion + " but " + "the standalone version " + MIN_REQUIRED_JCO_VERSION + " or a higher patch level is required.");
            }
        }
        catch (ClassNotFoundException cnfe) {
            int index = VERSION.indexOf(32);
            String ownVersion = index >= 0 ? VERSION.substring(0, index) : VERSION;
            throw new IDocRuntimeException("Initialization of the SAP Java IDoc Class Library " + ownVersion + " failed. " + "The SAP Java Connector either cannot be found or cannot be initialized.", cnfe);
        }
        catch (NumberFormatException nfe) {
        }
        catch (IDocRuntimeException ire) {
            throw ire;
        }
        catch (Exception e) {
            int index = VERSION.indexOf(32);
            String ownVersion = index >= 0 ? VERSION.substring(0, index) : VERSION;
            throw new IDocRuntimeException("Initialization of the SAP Java IDoc Class Library " + ownVersion + " failed. " + "The IDoc runtime environment cannot be initialized.", e);
        }
        runtime = new DefaultJCoIDocRuntime();
        runtime.readSystemProperties();
    }

    static class DefaultJCoIDocRuntime
    extends JCoIDocRuntime {
        DefaultJCoIDocRuntime() {
        }

        public String getVersion() {
            return JCoIDoc.VERSION;
        }

        protected IDocRepository createIDocRepository(JCoDestination destination) throws JCoException {
            return super.createRepository(destination);
        }

        protected JCoFunction createJCoFunction(IDocDocumentList docList, char iDocVersion, int options, JCoAttributes attributes, String qname) {
            return super.createJCoFunction(docList, iDocVersion, options, attributes, qname);
        }

        protected JCoFunction createJCoFunction(IDocDocument doc, char iDocVersion, int options, JCoAttributes attributes, String qname) {
            return super.createJCoFunction(doc, iDocVersion, options, attributes, qname);
        }

        protected JCoIDocDocumentList[] createIDocDocumentListArray(IDocRepository repository, RawTable controlTable, RawTable dataTable, boolean dataTableContainsTypes, String binaryDataCharset, boolean usePartnerProfileRelease) throws IDocMetaDataUnavailableException {
            return super.createIDocDocumentListArray(repository, controlTable, dataTable, dataTableContainsTypes, binaryDataCharset, usePartnerProfileRelease);
        }

        protected void readSystemProperties() {
            super.readSystemProperties();
        }
    }
}

