/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v2alpha1

import (
	internalinterfaces "github.com/rh-messaging/activemq-artemis-operator/pkg/client/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// ActiveMQArtemises returns a ActiveMQArtemisInformer.
	ActiveMQArtemises() ActiveMQArtemisInformer
	// ActiveMQArtemisAddresses returns a ActiveMQArtemisAddressInformer.
	ActiveMQArtemisAddresses() ActiveMQArtemisAddressInformer
	// ActiveMQArtemisScaledowns returns a ActiveMQArtemisScaledownInformer.
	ActiveMQArtemisScaledowns() ActiveMQArtemisScaledownInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// ActiveMQArtemises returns a ActiveMQArtemisInformer.
func (v *version) ActiveMQArtemises() ActiveMQArtemisInformer {
	return &activeMQArtemisInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// ActiveMQArtemisAddresses returns a ActiveMQArtemisAddressInformer.
func (v *version) ActiveMQArtemisAddresses() ActiveMQArtemisAddressInformer {
	return &activeMQArtemisAddressInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// ActiveMQArtemisScaledowns returns a ActiveMQArtemisScaledownInformer.
func (v *version) ActiveMQArtemisScaledowns() ActiveMQArtemisScaledownInformer {
	return &activeMQArtemisScaledownInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
