package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-generated-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_CertInfo = map[string]string{
	"":         "CertInfo relates a certificate with a private key",
	"certFile": "CertFile is a file containing a PEM-encoded certificate",
	"keyFile":  "KeyFile is a file containing a PEM-encoded private key for the certificate specified by CertFile",
}

func (CertInfo) SwaggerDoc() map[string]string {
	return map_CertInfo
}

var map_ClusterInfo = map[string]string{
	"":                 "ClusterInfo holds information the web console needs to talk to the cluster such as master public URL and metrics public URL",
	"consolePublicURL": "ConsolePublicURL is where you can find the web console server (TODO do we really need this?)",
	"masterPublicURL":  "MasterPublicURL is how the web console can access the OpenShift v1 server",
	"loggingPublicURL": "LoggingPublicURL is the public endpoint for logging (optional)",
	"metricsPublicURL": "MetricsPublicURL is the public endpoint for metrics (optional)",
	"logoutPublicURL":  "LogoutPublicURL is an optional, absolute URL to redirect web browsers to after logging out of the web console. If not specified, the built-in logout page is shown.",
}

func (ClusterInfo) SwaggerDoc() map[string]string {
	return map_ClusterInfo
}

var map_ExtensionsConfiguration = map[string]string{
	"":               "ExtensionsConfiguration holds custom script, stylesheets, and properties used for web console customization",
	"scriptURLs":     "ScriptURLs are URLs to load as scripts when the Web Console loads. The URLs must be accessible from the browser.",
	"stylesheetURLs": "StylesheetURLs are URLs to load as stylesheets when the Web Console loads. The URLs must be accessible from the browser.",
	"properties":     "Properties are key(string) and value(string) pairs that will be injected into the console under the global variable OPENSHIFT_EXTENSION_PROPERTIES",
}

func (ExtensionsConfiguration) SwaggerDoc() map[string]string {
	return map_ExtensionsConfiguration
}

var map_FeaturesConfiguration = map[string]string{
	"": "FeaturesConfiguration defines various feature gates for the web console",
	"inactivityTimeoutMinutes":        "InactivityTimeoutMinutes is the number of minutes of inactivity before you are automatically logged out of the web console (optional). If set to 0, inactivity timeout is disabled.",
	"clusterResourceOverridesEnabled": "ClusterResourceOverridesEnabled indicates that the cluster is configured for overcommit. When set to true, the web console will hide the CPU request, CPU limit, and memory request fields in its editors and skip validation on those fields. The memory limit field will still be displayed.",
}

func (FeaturesConfiguration) SwaggerDoc() map[string]string {
	return map_FeaturesConfiguration
}

var map_HTTPServingInfo = map[string]string{
	"": "HTTPServingInfo holds configuration for serving HTTP",
	"maxRequestsInFlight":   "MaxRequestsInFlight is the number of concurrent requests allowed to the server. If zero, no limit.",
	"requestTimeoutSeconds": "RequestTimeoutSeconds is the number of seconds before requests are timed out. The default is 60 minutes, if -1 there is no limit on requests.",
}

func (HTTPServingInfo) SwaggerDoc() map[string]string {
	return map_HTTPServingInfo
}

var map_NamedCertificate = map[string]string{
	"":      "NamedCertificate specifies a certificate/key, and the names it should be served for",
	"names": "Names is a list of DNS names this certificate should be used to secure A name can be a normal DNS name, or can contain leading wildcard segments.",
}

func (NamedCertificate) SwaggerDoc() map[string]string {
	return map_NamedCertificate
}

var map_ServingInfo = map[string]string{
	"":                  "ServingInfo holds information about serving web pages",
	"bindAddress":       "BindAddress is the ip:port to serve on",
	"bindNetwork":       "BindNetwork is the type of network to bind to - defaults to \"tcp4\", accepts \"tcp\", \"tcp4\", and \"tcp6\"",
	"clientCA":          "ClientCA is the certificate bundle for all the signers that you'll recognize for incoming client certificates",
	"namedCertificates": "NamedCertificates is a list of certificates to use to secure requests to specific hostnames",
	"minTLSVersion":     "MinTLSVersion is the minimum TLS version supported. Values must match version names from https://golang.org/pkg/crypto/tls/#pkg-constants",
	"cipherSuites":      "CipherSuites contains an overridden list of ciphers for the server to support. Values must match cipher suite IDs from https://golang.org/pkg/crypto/tls/#pkg-constants",
}

func (ServingInfo) SwaggerDoc() map[string]string {
	return map_ServingInfo
}

var map_WebConsoleConfiguration = map[string]string{
	"":            "WebConsoleConfiguration holds the necessary configuration options for serving the web console",
	"servingInfo": "ServingInfo is the HTTP serving information for these assets",
	"clusterInfo": "ClusterInfo holds information the web console needs to talk to the cluster such as master public URL and metrics public URL",
	"features":    "Features define various feature gates for the web console",
	"extensions":  "Extensions define custom scripts, stylesheets, and properties used for web console customization",
}

func (WebConsoleConfiguration) SwaggerDoc() map[string]string {
	return map_WebConsoleConfiguration
}

// AUTO-GENERATED FUNCTIONS END HERE
