﻿//  ------------------------------------------------------------------------------------
//  Copyright (c) Microsoft Corporation
//  All rights reserved. 
//  
//  Licensed under the Apache License, Version 2.0 (the ""License""); you may not use this 
//  file except in compliance with the License. You may obtain a copy of the License at 
//  http://www.apache.org/licenses/LICENSE-2.0  
//  
//  THIS CODE IS PROVIDED *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
//  EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED WARRANTIES OR 
//  CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE, MERCHANTABLITY OR 
//  NON-INFRINGEMENT. 
// 
//  See the Apache Version 2.0 License for specific language governing permissions and 
//  limitations under the License.
//  ------------------------------------------------------------------------------------

namespace Amqp.Serialization
{
    /// <summary>
    /// Defines the encoding type of an AMQP serializable type.
    /// </summary>
    public enum EncodingType
    {
        /// <summary>
        /// The type is encoded as an AMQP described list.
        /// </summary>
        List,

        /// <summary>
        /// The type is encoded as an AMQP described map.
        /// </summary>
        Map,

        /// <summary>
        /// The type is encoded as an AMQP map with string keys.
        /// </summary>
        SimpleMap,

        /// <summary>
        /// The type is encoded as an AMQP list with no descriptor.
        /// </summary>
        SimpleList,
    }
}
