/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

#include <proton/connection.hpp>
#include <proton/container.hpp>
#include <proton/delivery.hpp>
#include <proton/message.hpp>
#include <proton/messaging_handler.hpp>
#include <proton/receiver_options.hpp>
#include <proton/source_options.hpp>

#include <iostream>

#include "fake_cpp11.hpp"

class queue_browser : public proton::messaging_handler {
    std::string conn_url_;
    std::string addr_;

  public:
    queue_browser(const std::string& u, const std::string& a) :
        conn_url_(u), addr_(a) {}

    void on_container_start(proton::container& c) OVERRIDE {
        proton::receiver_options ropts;
        proton::source_options sopts;
        ropts.source(sopts.distribution_mode(proton::source::COPY));

        proton::connection conn = c.connect(conn_url_);
        conn.open_receiver(addr_, ropts);
    }

    void on_message(proton::delivery&, proton::message& m) OVERRIDE {
        std::cout << m.body() << std::endl;
    }
};

int main(int argc, char** argv) {
    try {
        std::string conn_url = argc > 1 ? argv[1] : "//127.0.0.1:5672";
        std::string addr = argc > 2 ? argv[2] : "examples";

        queue_browser qb(conn_url, addr);
        proton::container(qb).run();

        return 0;
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 1;
}
