TOPDIR=$(dir $(lastword $(MAKEFILE_LIST)))
include $(TOPDIR)/Makefile.common
ifeq ($(SKIP_TESTS),true)
MAVEN_ARGS="-DskipTests"
endif
ifneq ($(strip $(PROJECT_DISPLAY_NAME)),)
	MAVEN_ARGS+="-Dapplication.display.name=$(PROJECT_DISPLAY_NAME)"
endif

ifneq ($(FULL_BUILD),true)
build:
	cd $(TOPDIR); mvn clean install $(MAVEN_ARGS)

test:
ifeq ($(SKIP_TESTS),true)
	$(warning "java tests will be skipped")
else
	mvn test $(MAVEN_ARGS)
endif

package_java:
	mvn package -DskipTests $(MAVEN_ARGS)

package: package_java
endif

ifneq ($(FULL_BUILD),true)
clean_java: 
	mvn clean $(MAVEN_ARGS)
	rm -rf build target
else
clean_java:
	rm -rf build target
endif

clean: clean_java
