/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.internalClients;

import io.fabric8.kubernetes.api.model.Container;
import io.strimzi.systemtest.kafkaclients.internalClients.ClientArgument;
import io.strimzi.systemtest.kafkaclients.internalClients.ClientArgumentMap;
import io.strimzi.systemtest.kafkaclients.internalClients.ClientType;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.executor.Exec;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerifiableClient {
    private static final Logger LOGGER = LogManager.getLogger(VerifiableClient.class);
    private List<ClientArgument> allowedArguments = new ArrayList<ClientArgument>();
    private final Object lock = new Object();
    private List<String> messages = new ArrayList<String>();
    private List<String> arguments = new ArrayList<String>();
    private String executable;
    private Exec executor;
    private ClientType clientType;
    private String podName;
    private String podNamespace;
    private String bootstrapServer;
    private String topicName;
    private int maxMessages;
    private String kafkaUsername;
    private String consumerGroupName;
    private String consumerInstanceId;
    private ClientArgumentMap clientArgumentMap;

    public VerifiableClient(VerifiableClientBuilder verifiableClientBuilder) {
        String image;
        String clientVersion;
        this.clientType = verifiableClientBuilder.clientType;
        this.podName = verifiableClientBuilder.podName;
        this.podNamespace = verifiableClientBuilder.podNamespace;
        this.bootstrapServer = verifiableClientBuilder.bootstrapServer;
        this.topicName = verifiableClientBuilder.topicName;
        this.maxMessages = verifiableClientBuilder.maxMessages;
        this.kafkaUsername = verifiableClientBuilder.kafkaUsername;
        this.setAllowedArguments(this.clientType);
        this.clientArgumentMap = new ClientArgumentMap();
        this.clientArgumentMap.put(ClientArgument.TOPIC, this.topicName);
        this.clientArgumentMap.put(ClientArgument.MAX_MESSAGES, Integer.toString(this.maxMessages));
        if (this.kafkaUsername != null) {
            this.clientArgumentMap.put(ClientArgument.USER, this.kafkaUsername.replace("-", "_"));
        }
        this.clientArgumentMap.put(this.allowParameter("2.5.0", clientVersion = (image = ((Container)ResourceManager.kubeClient().getPod(this.podName).getSpec().getContainers().get(0)).getImage()).substring(image.length() - 5)) ? ClientArgument.BOOTSTRAP_SERVER : ClientArgument.BROKER_LIST, this.bootstrapServer);
        if (this.clientType == ClientType.CLI_KAFKA_VERIFIABLE_CONSUMER) {
            this.consumerGroupName = verifiableClientBuilder.consumerGroupName;
            this.clientArgumentMap.put(ClientArgument.GROUP_ID, this.consumerGroupName);
            if (this.allowParameter("2.3.0", clientVersion)) {
                this.consumerInstanceId = verifiableClientBuilder.consumerInstanceId;
                this.clientArgumentMap.put(ClientArgument.GROUP_INSTANCE_ID, this.consumerInstanceId);
            }
        }
        LOGGER.debug("This is all args {}, which are set.", (Object)this.clientArgumentMap);
        this.setArguments(this.clientArgumentMap);
        this.executable = ClientType.getCommand(this.clientType);
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setArguments(ClientArgumentMap args) {
        this.arguments.clear();
        for (ClientArgument arg : args.getArguments()) {
            if (this.validateArgument(arg)) {
                for (String value : args.getValues(arg)) {
                    if (arg.equals((Object)ClientArgument.USER)) {
                        String argument = String.format("%s=%s", arg.command(), value);
                        this.arguments.add(argument);
                        continue;
                    }
                    this.arguments.add(arg.command());
                    if (value.isEmpty()) continue;
                    this.arguments.add(value);
                }
                continue;
            }
            LOGGER.warn(String.format("Argument '%s' is not allowed for '%s'", arg.command(), this.getClass().getSimpleName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runClient(long timeoutMs, boolean logToOutput) {
        this.messages.clear();
        try {
            this.executor = new Exec();
            ArrayList<String> command = this.prepareCommand();
            LOGGER.info("Client command: {}", (Object)String.join((CharSequence)" ", command));
            int ret = this.executor.execute(null, command, timeoutMs);
            Object object = this.lock;
            synchronized (object) {
                if (logToOutput) {
                    if (ret == 0) {
                        this.parseToList(this.executor.out());
                    } else {
                        LOGGER.info("{} RETURN code: {}", (Object)this.clientType, (Object)ret);
                        if (!this.executor.out().isEmpty()) {
                            LOGGER.info("======STDOUT START=======");
                            LOGGER.info("{}", (Object)Exec.cutExecutorLog((String)this.executor.out()));
                            LOGGER.info("======STDOUT END======");
                        }
                        if (!this.executor.err().isEmpty()) {
                            LOGGER.info("======STDERR START=======");
                            LOGGER.info("{}", (Object)Exec.cutExecutorLog((String)this.executor.err()));
                            LOGGER.info("======STDERR END======");
                        }
                    }
                }
            }
            return ret == 0;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void parseToList(String data) {
        if (data != null) {
            for (String line : data.split(System.getProperty("line.separator"))) {
                if (Objects.equals(line, "") || line.trim().isEmpty()) continue;
                try {
                    this.messages.add(line);
                }
                catch (Exception ignored) {
                    LOGGER.warn("{} - Failed to parse client output '{}' as JSON", (Object)this.clientType, (Object)line);
                }
            }
        }
    }

    private ArrayList<String> prepareCommand() {
        ArrayList<String> command = new ArrayList<String>(this.arguments);
        ArrayList<String> executableCommand = new ArrayList<String>();
        executableCommand.addAll(Arrays.asList(KubeClusterResource.cmdKubeClient().toString(), "exec", this.podName, "-n", this.podNamespace, "--"));
        executableCommand.add(this.executable);
        executableCommand.addAll(command);
        return executableCommand;
    }

    public boolean run(long timeoutMs) {
        return this.runClient(timeoutMs, true);
    }

    public void stop() {
        try {
            this.executor.stop();
        }
        catch (Exception ex) {
            LOGGER.warn("Client stop raise exception: " + ex.getMessage());
        }
    }

    private boolean validateArgument(ClientArgument arg) {
        return this.allowedArguments.contains((Object)arg);
    }

    protected void setAllowedArguments(ClientType clientType) {
        switch (clientType) {
            case CLI_KAFKA_VERIFIABLE_PRODUCER: {
                this.allowedArguments.add(ClientArgument.TOPIC);
                this.allowedArguments.add(ClientArgument.BOOTSTRAP_SERVER);
                this.allowedArguments.add(ClientArgument.BROKER_LIST);
                this.allowedArguments.add(ClientArgument.MAX_MESSAGES);
                this.allowedArguments.add(ClientArgument.THROUGHPUT);
                this.allowedArguments.add(ClientArgument.ACKS);
                this.allowedArguments.add(ClientArgument.PRODUCER_CONFIG);
                this.allowedArguments.add(ClientArgument.MESSAGE_CREATE_TIME);
                this.allowedArguments.add(ClientArgument.VALUE_PREFIX);
                this.allowedArguments.add(ClientArgument.REPEATING_KEYS);
                this.allowedArguments.add(ClientArgument.USER);
                break;
            }
            case CLI_KAFKA_VERIFIABLE_CONSUMER: {
                this.allowedArguments.add(ClientArgument.BOOTSTRAP_SERVER);
                this.allowedArguments.add(ClientArgument.BROKER_LIST);
                this.allowedArguments.add(ClientArgument.TOPIC);
                this.allowedArguments.add(ClientArgument.GROUP_ID);
                this.allowedArguments.add(ClientArgument.MAX_MESSAGES);
                this.allowedArguments.add(ClientArgument.SESSION_TIMEOUT);
                this.allowedArguments.add(ClientArgument.VERBOSE);
                this.allowedArguments.add(ClientArgument.ENABLE_AUTOCOMMIT);
                this.allowedArguments.add(ClientArgument.RESET_POLICY);
                this.allowedArguments.add(ClientArgument.ASSIGMENT_STRATEGY);
                this.allowedArguments.add(ClientArgument.CONSUMER_CONFIG);
                this.allowedArguments.add(ClientArgument.USER);
                this.allowedArguments.add(ClientArgument.GROUP_INSTANCE_ID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected client type!");
            }
        }
    }

    public String getBootstrapServer() {
        return this.bootstrapServer;
    }

    private boolean allowParameter(String minimalVersion, String clientVersion) {
        Pattern pattern = Pattern.compile("(?<major>[0-9]).(?<minor>[0-9]).(?<micro>[0-9])");
        Matcher current = pattern.matcher(clientVersion);
        Matcher minimal = pattern.matcher(minimalVersion);
        if (current.find() && minimal.find()) {
            return Integer.parseInt(current.group("major")) >= Integer.parseInt(minimal.group("major")) && Integer.parseInt(current.group("minor")) >= Integer.parseInt(minimal.group("minor")) && Integer.parseInt(current.group("micro")) >= Integer.parseInt(minimal.group("micro"));
        }
        return false;
    }

    public String toString() {
        return "VerifiableClient{allowedArguments=" + this.allowedArguments + ", lock=" + this.lock + ", messages=" + this.messages + ", arguments=" + this.arguments + ", executable='" + this.executable + "', executor=" + this.executor + ", clientType=" + this.clientType + ", podName='" + this.podName + "', podNamespace='" + this.podNamespace + "', bootstrapServer='" + this.bootstrapServer + "', topicName='" + this.topicName + "', maxMessages=" + this.maxMessages + ", kafkaUsername='" + this.kafkaUsername + "', consumerGroupName='" + this.consumerGroupName + "', consumerInstanceId='" + this.consumerInstanceId + "', clientArgumentMap=" + this.clientArgumentMap + "}";
    }

    public static class VerifiableClientBuilder {
        private ClientType clientType;
        private String podName;
        private String podNamespace;
        private String bootstrapServer;
        private String topicName;
        private int maxMessages;
        private String kafkaUsername;
        private String consumerGroupName;
        private String consumerInstanceId;

        public VerifiableClientBuilder withClientType(ClientType clientType) {
            this.clientType = clientType;
            return this;
        }

        public VerifiableClientBuilder withUsingPodName(String podName) {
            this.podName = podName;
            return this;
        }

        public VerifiableClientBuilder withPodNamespace(String podNamespace) {
            this.podNamespace = podNamespace;
            return this;
        }

        public VerifiableClientBuilder withBootstrapServer(String bootstrapServer) {
            this.bootstrapServer = bootstrapServer;
            return this;
        }

        public VerifiableClientBuilder withTopicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public VerifiableClientBuilder withMaxMessages(int maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        public VerifiableClientBuilder withKafkaUsername(String kafkaUsername) {
            this.kafkaUsername = kafkaUsername;
            return this;
        }

        public VerifiableClientBuilder withConsumerGroupName(String consumerGroupName) {
            this.consumerGroupName = consumerGroupName;
            return this;
        }

        public VerifiableClientBuilder withConsumerInstanceId(String consumerInstanceId) {
            this.consumerInstanceId = consumerInstanceId;
            return this;
        }

        protected VerifiableClient build() {
            return new VerifiableClient(this);
        }
    }
}

