/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.matchers;

import io.fabric8.kubernetes.api.model.Event;
import io.strimzi.systemtest.k8s.Events;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class HasNoneOfReasons
extends BaseMatcher<List<Event>> {
    private final Set<String> prohibitedEvents;

    public HasNoneOfReasons(Events ... eventReasons) {
        this.prohibitedEvents = Arrays.stream(eventReasons).map(Enum::name).collect(Collectors.toSet());
    }

    public boolean matches(Object actualValue) {
        return !this.filtered((List)actualValue).findFirst().isPresent();
    }

    private Stream<Event> filtered(List<Event> actualValue) {
        return actualValue.stream().filter(evt -> this.prohibitedEvents.contains(evt.getReason()));
    }

    public void describeMismatch(Object item, Description description) {
        this.describeTo(description);
        description.appendValueList(" but actual event reasons were {", ", ", "}.", (Iterable)((List)item).stream().map(evt -> {
            Object objRef = "";
            if (evt.getInvolvedObject() != null) {
                objRef = " involved object: " + evt.getInvolvedObject().getKind() + "/" + evt.getInvolvedObject().getName();
            }
            return evt.getReason() + " (" + evt.getType() + " " + evt.getMessage() + (String)objRef + ")\n";
        }).collect(Collectors.toList()));
    }

    public void describeTo(Description description) {
        description.appendValueList("The resource should not contain no events with any of the reasons {", ", ", "}, ", this.prohibitedEvents);
    }
}

