/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectorList;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaConnectorBuilder;
import io.strimzi.api.kafka.model.KafkaConnectorFluent;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import java.util.function.Consumer;

public class KafkaConnectorResource {
    public static final String PATH_TO_KAFKA_CONNECTOR_CONFIG = TestUtils.USER_PATH + "/../examples/connect/source-connector.yaml";

    public static MixedOperation<KafkaConnector, KafkaConnectorList, Resource<KafkaConnector>> kafkaConnectorClient() {
        return Crds.kafkaConnectorOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaConnectorBuilder kafkaConnector(String name) {
        return KafkaConnectorResource.kafkaConnector(name, name, 2);
    }

    public static KafkaConnectorBuilder kafkaConnector(String name, String clusterName) {
        return KafkaConnectorResource.kafkaConnector(name, clusterName, 2);
    }

    public static KafkaConnectorBuilder kafkaConnector(String name, String clusterName, int maxTasks) {
        KafkaConnector kafkaConnector = KafkaConnectorResource.getKafkaConnectorFromYaml(PATH_TO_KAFKA_CONNECTOR_CONFIG);
        return KafkaConnectorResource.defaultKafkaConnector(kafkaConnector, name, clusterName, maxTasks);
    }

    public static KafkaConnectorBuilder defaultKafkaConnector(KafkaConnector kafkaConnector, String name, String kafkaConnectClusterName, int maxTasks) {
        return (KafkaConnectorBuilder)((KafkaConnectorFluent.SpecNested)((KafkaConnectorBuilder)((KafkaConnectorFluent.MetadataNested)((KafkaConnectorFluent.MetadataNested)((KafkaConnectorFluent.MetadataNested)new KafkaConnectorBuilder(kafkaConnector).editOrNewMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).addToLabels("strimzi.io/cluster", kafkaConnectClusterName)).endMetadata()).editOrNewSpec().withTasksMax(Integer.valueOf(maxTasks))).endSpec();
    }

    public static KafkaConnector kafkaConnectorWithoutWait(KafkaConnector kafkaConnector) {
        ((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaConnector[]{kafkaConnector});
        return kafkaConnector;
    }

    public static void deleteKafkaConnectorWithoutWait(String connectorName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(connectorName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    public static KafkaConnector createAndWaitForReadiness(KafkaConnector kafkaConnector) {
        TestUtils.waitFor((String)"KafkaConnector creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaConnector[]{kafkaConnector});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaConnectorResource.waitFor(KafkaConnectorResource.deleteLater(kafkaConnector));
    }

    private static KafkaConnector getKafkaConnectorFromYaml(String yamlPath) {
        return (KafkaConnector)TestUtils.configFromYaml((String)yamlPath, KafkaConnector.class);
    }

    private static KafkaConnector waitFor(KafkaConnector kafkaConnector) {
        return ResourceManager.waitForResourceStatus(KafkaConnectorResource.kafkaConnectorClient(), kafkaConnector, CustomResourceStatus.Ready);
    }

    private static KafkaConnector deleteLater(KafkaConnector kafkaConnector) {
        return ResourceManager.deleteLater(KafkaConnectorResource.kafkaConnectorClient(), kafkaConnector);
    }

    public static void replaceKafkaConnectorResource(String resourceName, Consumer<KafkaConnector> editor) {
        ResourceManager.replaceCrdResource(KafkaConnector.class, KafkaConnectorList.class, resourceName, editor);
    }
}

