/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd.kafkaclients;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.strimzi.systemtest.resources.KubernetesResource;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.utils.ClientUtils;
import java.security.InvalidParameterException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaBasicExampleClients {
    private static final Logger LOGGER = LogManager.getLogger(KafkaBasicExampleClients.class);
    protected String producerName;
    protected String consumerName;
    protected String bootstrapAddress;
    protected String topicName;
    protected int messageCount;
    protected String additionalConfig;
    protected String consumerGroup;
    protected long delayMs;

    protected KafkaBasicExampleClients(Builder builder) {
        if (builder.topicName == null || builder.topicName.isEmpty()) {
            throw new InvalidParameterException("Topic name is not set.");
        }
        if (builder.bootstrapAddress == null || builder.bootstrapAddress.isEmpty()) {
            throw new InvalidParameterException("Bootstrap server is not set.");
        }
        if (builder.messageCount <= 0) {
            throw new InvalidParameterException("Message count is less than 1");
        }
        if (builder.consumerGroup == null || builder.consumerGroup.isEmpty()) {
            LOGGER.info("Consumer group were not specified going to create the random one.");
            builder.consumerGroup = ClientUtils.generateRandomConsumerGroup();
        }
        this.producerName = builder.producerName;
        this.consumerName = builder.consumerName;
        this.bootstrapAddress = builder.bootstrapAddress;
        this.topicName = builder.topicName;
        this.messageCount = builder.messageCount;
        this.additionalConfig = builder.additionalConfig;
        this.consumerGroup = builder.consumerGroup;
        this.delayMs = builder.delayMs;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public String getBootstrapAddress() {
        return this.bootstrapAddress;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public String getAdditionalConfig() {
        return this.additionalConfig;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public long getDelayMs() {
        return this.delayMs;
    }

    protected Builder newBuilder() {
        return new Builder();
    }

    protected Builder updateBuilder(Builder builder) {
        return builder.withConsumerGroup(this.getConsumerGroup()).withAdditionalConfig(this.getAdditionalConfig()).withBootstrapAddress(this.getBootstrapAddress()).withConsumerName(this.getConsumerName()).withDelayMs(this.getDelayMs()).withMessageCount(this.getMessageCount()).withProducerName(this.getProducerName()).withTopicName(this.getTopicName());
    }

    public Builder toBuilder() {
        return this.updateBuilder(this.newBuilder());
    }

    public JobBuilder producerStrimzi() {
        return this.defaultProducerStrimzi();
    }

    public JobBuilder consumerStrimzi() {
        return this.defaultConsumerStrimzi();
    }

    public JobBuilder defaultProducerStrimzi() {
        if (this.producerName == null || this.producerName.isEmpty()) {
            throw new InvalidParameterException("Producer name is not set.");
        }
        HashMap<String, String> producerLabels = new HashMap<String, String>();
        producerLabels.put("app", this.producerName);
        producerLabels.put("user-test-app", "kafka-clients");
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(producerLabels)).withName(this.producerName)).endMetadata()).withNewSpec().withBackoffLimit(Integer.valueOf(0))).withNewTemplate().withNewMetadata().withLabels(producerLabels)).endMetadata()).withNewSpec().withRestartPolicy("Never")).withContainers(new Container[0])).addNewContainer().withName(this.producerName)).withImagePullPolicy("IfNotPresent")).withImage("quay.io/strimzi-examples/java-kafka-producer:latest")).addNewEnv().withName("BOOTSTRAP_SERVERS")).withValue(this.bootstrapAddress)).endEnv()).addNewEnv().withName("TOPIC")).withValue(this.topicName)).endEnv()).addNewEnv().withName("DELAY_MS")).withValue(String.valueOf(this.delayMs))).endEnv()).addNewEnv().withName("LOG_LEVEL")).withValue("DEBUG")).endEnv()).addNewEnv().withName("MESSAGE_COUNT")).withValue(String.valueOf(this.messageCount))).endEnv()).addNewEnv().withName("MESSAGE")).withValue("Hello-world")).endEnv()).addNewEnv().withName("PRODUCER_ACKS")).withValue("all")).endEnv()).addNewEnv().withName("ADDITIONAL_CONFIG")).withValue(this.additionalConfig)).endEnv()).addNewEnv().withName("BLOCKING_PRODUCER")).withValue("true")).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public JobBuilder defaultConsumerStrimzi() {
        if (this.consumerName == null || this.consumerName.isEmpty()) {
            throw new InvalidParameterException("Consumer name is not set.");
        }
        HashMap<String, String> consumerLabels = new HashMap<String, String>();
        consumerLabels.put("app", this.consumerName);
        consumerLabels.put("user-test-app", "kafka-clients");
        return (JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)new JobBuilder().withNewMetadata().withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(consumerLabels)).withName(this.consumerName)).endMetadata()).withNewSpec().withBackoffLimit(Integer.valueOf(0))).withNewTemplate().withNewMetadata().withLabels(consumerLabels)).endMetadata()).withNewSpec().withRestartPolicy("Never")).withContainers(new Container[0])).addNewContainer().withName(this.consumerName)).withImagePullPolicy("IfNotPresent")).withImage("quay.io/strimzi-examples/java-kafka-consumer:latest")).addNewEnv().withName("BOOTSTRAP_SERVERS")).withValue(this.bootstrapAddress)).endEnv()).addNewEnv().withName("TOPIC")).withValue(this.topicName)).endEnv()).addNewEnv().withName("DELAY_MS")).withValue(String.valueOf(this.delayMs))).endEnv()).addNewEnv().withName("LOG_LEVEL")).withValue("DEBUG")).endEnv()).addNewEnv().withName("MESSAGE_COUNT")).withValue(String.valueOf(this.messageCount))).endEnv()).addNewEnv().withName("GROUP_ID")).withValue(this.consumerGroup)).endEnv()).addNewEnv().withName("ADDITIONAL_CONFIG")).withValue(this.additionalConfig)).endEnv()).endContainer()).endSpec()).endTemplate()).endSpec();
    }

    public Job createAndWaitForReadiness(Job job) {
        return KubernetesResource.deployNewJob(job);
    }

    public static class Builder {
        private String producerName;
        private String consumerName;
        private String bootstrapAddress;
        private String topicName;
        private int messageCount;
        private String additionalConfig;
        private String consumerGroup;
        private long delayMs;

        public Builder withProducerName(String producerName) {
            this.producerName = producerName;
            return this;
        }

        public Builder withConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public Builder withBootstrapAddress(String bootstrapAddress) {
            this.bootstrapAddress = bootstrapAddress;
            return this;
        }

        public Builder withTopicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public Builder withMessageCount(int messageCount) {
            this.messageCount = messageCount;
            return this;
        }

        public Builder withAdditionalConfig(String additionalConfig) {
            this.additionalConfig = additionalConfig;
            return this;
        }

        public Builder withConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
            return this;
        }

        public Builder withDelayMs(long delayMs) {
            this.delayMs = delayMs;
            return this;
        }

        public KafkaBasicExampleClients build() {
            return new KafkaBasicExampleClients(this);
        }
    }
}

