/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.kafkaclients.KafkaClientOperations;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import java.time.Duration;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientUtils {
    private static final Logger LOGGER = LogManager.getLogger(ClientUtils.class);
    private static final String CONSUMER_GROUP_NAME = "my-consumer-group-";
    private static Random rng = new Random();

    private ClientUtils() {
    }

    public static void waitUntilClientReceivedMessagesTls(KafkaClientOperations kafkaClient, int exceptedMessages) throws Exception {
        int tries = 1;
        while (true) {
            int receivedMessages;
            if ((receivedMessages = kafkaClient.receiveMessagesTls(Constants.GLOBAL_CLIENTS_TIMEOUT)) == exceptedMessages) break;
            LOGGER.warn("Client not received excepted messages {}, instead received only {}!", (Object)exceptedMessages, (Object)receivedMessages);
            if (tries == 3) {
                throw new RuntimeException(String.format("Consumer wasn't able to consume %s messages for 3 times", exceptedMessages));
            }
            ++tries;
        }
        LOGGER.info("Consumer successfully consumed {} messages for the {} time", (Object)exceptedMessages, (Object)tries);
    }

    public static void waitTillContinuousClientsFinish(String producerName, String consumerName, String namespace, int messageCount) {
        LOGGER.info("Waiting till producer {} and consumer {} finish", (Object)producerName, (Object)consumerName);
        TestUtils.waitFor((String)"continuous clients finished", (long)Constants.GLOBAL_POLL_INTERVAL, (long)ClientUtils.timeoutForClientFinishJob(messageCount), () -> ResourceManager.kubeClient().getJobStatus(producerName) != false && ResourceManager.kubeClient().getJobStatus(consumerName) != false);
    }

    public static void waitForClientSuccess(String jobName, String namespace, int messageCount) {
        LOGGER.info("Waiting for producer/consumer:{} will be finished", (Object)jobName);
        TestUtils.waitFor((String)"job finished", (long)Constants.GLOBAL_POLL_INTERVAL, (long)ClientUtils.timeoutForClientFinishJob(messageCount), () -> ResourceManager.kubeClient().namespace(namespace).getJobStatus(jobName));
    }

    private static long timeoutForClientFinishJob(int messagesCount) {
        return (long)messagesCount * 1000L + Duration.ofMinutes(2L).toMillis();
    }

    public static String generateRandomConsumerGroup() {
        int salt = rng.nextInt(Integer.MAX_VALUE);
        return CONSUMER_GROUP_NAME + salt;
    }
}

