/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.controllers;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigMapUtils {
    private static final Logger LOGGER = LogManager.getLogger(ConfigMapUtils.class);
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private ConfigMapUtils() {
    }

    public static void waitForConfigMapRecovery(String name, String configMapUid) {
        LOGGER.info("Waiting for config map {}-{} recovery in namespace {}", (Object)name, (Object)configMapUid, (Object)KubeClusterResource.kubeClient().getNamespace());
        TestUtils.waitFor((String)("Config map " + name + " to be recovered"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.TIMEOUT_FOR_RESOURCE_RECOVERY, () -> !KubeClusterResource.kubeClient().getConfigMapUid(name).equals(configMapUid));
        LOGGER.info("Config map {} was recovered", (Object)name);
    }

    public static void waitForConfigMapLabelsChange(String configMapName, Map<String, String> labels) {
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            boolean isK8sTag;
            boolean bl = isK8sTag = entry.getKey().equals("controller-revision-hash") || entry.getKey().equals("statefulset.kubernetes.io/pod-name");
            boolean isStrimziTag = entry.getKey().startsWith("strimzi.io/");
            if (isStrimziTag || isK8sTag) continue;
            LOGGER.info("Waiting for ConfigMap {} label change {} -> {}", (Object)configMapName, (Object)entry.getKey(), (Object)entry.getValue());
            TestUtils.waitFor((String)("ConfigMap label change " + entry.getKey() + " -> " + entry.getValue()), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.GLOBAL_TIMEOUT, () -> ((String)KubeClusterResource.kubeClient().getConfigMap(configMapName).getMetadata().getLabels().get(entry.getKey())).equals(entry.getValue()));
        }
    }

    public static void waitForConfigMapLabelsDeletion(String configMapName, String ... labelKeys) {
        for (String labelKey : labelKeys) {
            LOGGER.info("Waiting for ConfigMap {} label {} change to {}", (Object)configMapName, (Object)labelKey, null);
            TestUtils.waitFor((String)("Kafka configMap label" + labelKey + " change to null"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().getConfigMap(configMapName).getMetadata().getLabels().get(labelKey) == null);
            LOGGER.info("ConfigMap {} label {} change to {}", (Object)configMapName, (Object)labelKey, null);
        }
    }

    public static void waitUntilConfigMapDeletion(String clusterName) {
        LOGGER.info("Waiting for all ConfigMaps of cluster {} deletion", (Object)clusterName);
        TestUtils.waitFor((String)"ConfigMaps will be deleted {}", (long)Constants.GLOBAL_POLL_INTERVAL, (long)DELETION_TIMEOUT, () -> {
            List cmList = KubeClusterResource.kubeClient().listConfigMaps().stream().filter(cm -> cm.getMetadata().getName().contains(clusterName)).collect(Collectors.toList());
            if (cmList.isEmpty()) {
                return true;
            }
            for (ConfigMap cm2 : cmList) {
                LOGGER.warn("ConfigMap {} is not deleted yet! Triggering force delete by cmd client!", (Object)cm2.getMetadata().getName());
                ResourceManager.cmdKubeClient().deleteByName("configmap", cm2.getMetadata().getName());
            }
            return false;
        });
        LOGGER.info("ConfigMaps of cluster {} were deleted", (Object)clusterName);
    }
}

