/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.controllers;

import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.utils.kubeUtils.objects.PodUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentConfigUtils {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentConfigUtils.class);
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("DeploymentConfig");
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    public static Map<String, String> depConfigSnapshot(String name) {
        LabelSelector selector = ((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels(KubeClusterResource.kubeClient().getDeploymentConfigSelectors(name))).build();
        return PodUtils.podSnapshot(selector);
    }

    public static boolean depConfigHasRolled(String name, Map<String, String> snapshot) {
        LOGGER.debug("Existing snapshot: {}", new TreeMap<String, String>(snapshot));
        LabelSelector selector = ((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels(KubeClusterResource.kubeClient().getDeploymentConfigSelectors(name))).build();
        Map<String, String> map = PodUtils.podSnapshot(selector);
        LOGGER.debug("Current  snapshot: {}", new TreeMap<String, String>(map));
        int current = map.size();
        map.keySet().retainAll(snapshot.keySet());
        if (current == snapshot.size() && map.isEmpty()) {
            LOGGER.info("All pods seem to have rolled");
            return true;
        }
        LOGGER.debug("Some pods still need to roll: {}", map);
        return false;
    }

    public static Map<String, String> waitTillDepConfigHasRolled(String depConfigName, Map<String, String> snapshot) {
        LOGGER.info("Waiting for DeploymentConfig {} rolling update", (Object)depConfigName);
        TestUtils.waitFor((String)("DeploymentConfig roll of " + depConfigName), (long)Constants.WAIT_FOR_ROLLING_UPDATE_INTERVAL, (long)ResourceOperation.timeoutForPodsOperation(snapshot.size()), () -> DeploymentConfigUtils.depConfigHasRolled(depConfigName, snapshot));
        DeploymentConfigUtils.waitForDeploymentConfigReady(depConfigName);
        LOGGER.info("DeploymentConfig {} rolling update finished", (Object)depConfigName);
        return DeploymentConfigUtils.depConfigSnapshot(depConfigName);
    }

    public static void waitForDeploymentConfigDeletion(String name) {
        LOGGER.debug("Waiting for DeploymentConfig {} deletion", (Object)name);
        TestUtils.waitFor((String)("DeploymentConfig " + name + " to be deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_DELETION, (long)DELETION_TIMEOUT, () -> {
            if (KubeClusterResource.kubeClient().getDeploymentConfig(name) == null) {
                return true;
            }
            LOGGER.warn("Deployment {} is not deleted yet! Triggering force delete by cmd client!", (Object)name);
            KubeClusterResource.cmdKubeClient().deleteByName("deploymentconfig", name);
            return false;
        });
        LOGGER.debug("DeploymentConfig {} was deleted", (Object)name);
    }

    public static Map<String, String> waitForDeploymentConfigAndPodsReady(String depConfigName, int expectPods) {
        DeploymentConfigUtils.waitForDeploymentConfigReady(depConfigName);
        LOGGER.info("Waiting for Pod(s) of DeploymentConfig {} to be ready", (Object)depConfigName);
        LabelSelector deploymentConfigSelector = ((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels(KubeClusterResource.kubeClient().getDeploymentConfigSelectors(depConfigName))).build();
        PodUtils.waitForPodsReady(deploymentConfigSelector, expectPods, true);
        LOGGER.info("DeploymentConfig {} is ready", (Object)depConfigName);
        return DeploymentConfigUtils.depConfigSnapshot(depConfigName);
    }

    public static void waitForDeploymentConfigReady(String depConfigName) {
        LOGGER.info("Wait for DeploymentConfig: {} will be ready", (Object)depConfigName);
        TestUtils.waitFor((String)String.format("Wait for DeploymentConfig: %s will be ready", depConfigName), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> KubeClusterResource.kubeClient().getDeploymentConfigReadiness(depConfigName), () -> {
            if (KubeClusterResource.kubeClient().getDeploymentConfig(depConfigName) != null) {
                LOGGER.info((Object)KubeClusterResource.kubeClient().getDeploymentConfig(depConfigName));
            }
        });
        LOGGER.info("Wait for DeploymentConfig: {} is ready", (Object)depConfigName);
    }
}

